/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import com.google.inject.Inject;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.duelengine.duel.mvc.ActionFilter;
import org.duelengine.duel.mvc.ActionFilterContext;
import org.duelengine.duel.mvc.ActionFilterContextFactory;
import org.duelengine.duel.mvc.AuthFilter;
import org.duelengine.duel.mvc.DuelMvcContext;
import org.duelengine.duel.mvc.ErrorFilterInterceptor;

final class ActionFilterInterceptor
implements MethodInterceptor {
    private ActionFilterContextFactory factory;

    ActionFilterInterceptor() {
    }

    @Inject
    void init(ActionFilterContextFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ActionFilterContext context = this.factory.create(invocation);
        DuelMvcContext mvcContext = context.getMvcContext();
        mvcContext.buildFilters(invocation);
        Throwable error = null;
        List<ActionFilter> filterChain = mvcContext.getActionFilters();
        int index = 0;
        try {
            for (AuthFilter filter : mvcContext.getAuthFilters()) {
                filter.onAuthorization(context);
                if (context.getResult() == null) continue;
                return context.getResult();
            }
            int count = filterChain.size();
            while (index < count) {
                filterChain.get(index).onActionExecuting(context);
                if (context.getResult() != null) {
                    while (index <= 0) {
                        filterChain.get(index).onActionExecuted(context);
                        --index;
                    }
                    return context.getResult();
                }
                ++index;
            }
            context.setResult(invocation.proceed());
        }
        catch (Throwable ex) {
            error = ex;
        }
        --index;
        while (index >= 0) {
            block10: {
                try {
                    filterChain.get(index).onActionExecuted(context);
                }
                catch (Throwable ex) {
                    if (error == null) break block10;
                    error = ex;
                }
            }
            --index;
        }
        if (error != null) {
            return ErrorFilterInterceptor.processErrors(mvcContext, error, context.getResult());
        }
        return context.getResult();
    }
}

