/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Stage;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.mvc.ActionFilter;
import org.duelengine.duel.mvc.Apply;
import org.duelengine.duel.mvc.AuthFilter;
import org.duelengine.duel.mvc.DuelMvcFilter;
import org.duelengine.duel.mvc.ErrorFilter;
import org.duelengine.duel.mvc.ResultFilter;

public class DuelMvcContext
extends DuelContext {
    private final Injector injector;
    private final Stage stage;
    private final ExtendedUriInfo uriInfo;
    private final List<AuthFilter> authFilters = new ArrayList<AuthFilter>();
    private final List<ActionFilter> actionFilters = new ArrayList<ActionFilter>();
    private final List<ResultFilter> resultFilters = new ArrayList<ResultFilter>();
    private final List<ErrorFilter> errorFilters = new ArrayList<ErrorFilter>();
    private boolean filtersApplied;

    @Inject
    public DuelMvcContext(Injector injector, Stage stage, ExtendedUriInfo uriInfo) {
        if (injector == null) {
            throw new NullPointerException("injector");
        }
        if (uriInfo == null) {
            throw new NullPointerException("uriInfo");
        }
        if (stage == null) {
            throw new NullPointerException("stage");
        }
        this.injector = injector;
        this.stage = stage;
        this.uriInfo = uriInfo;
    }

    public Stage getStage() {
        return this.stage;
    }

    public ExtendedUriInfo getUriInfo() {
        return this.uriInfo;
    }

    List<AuthFilter> getAuthFilters() {
        return this.authFilters;
    }

    List<ActionFilter> getActionFilters() {
        return this.actionFilters;
    }

    List<ResultFilter> getResultFilters() {
        return this.resultFilters;
    }

    List<ErrorFilter> getErrorFilters() {
        return this.errorFilters;
    }

    void ensureFilters() {
        if (this.filtersApplied) {
            return;
        }
        this.filtersApplied = true;
        AbstractResourceMethod method = this.uriInfo.getMatchedMethod();
        if (method == null) {
            return;
        }
        AbstractResource controller = method.getResource();
        if (controller != null) {
            for (Annotation annotation : controller.getResourceClass().getAnnotations()) {
                if (!(annotation instanceof Apply)) continue;
                this.addFilters((Apply)annotation);
            }
        }
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof Apply)) continue;
            this.addFilters((Apply)annotation);
        }
    }

    void buildFilters(MethodInvocation invocation) {
        if (this.filtersApplied) {
            return;
        }
        this.filtersApplied = true;
        Method method = invocation.getMethod();
        if (method == null) {
            return;
        }
        Object controller = invocation.getThis();
        if (controller != null) {
            this.addFilter(controller);
            for (Annotation annotation : controller.getClass().getAnnotations()) {
                if (!(annotation instanceof Apply)) continue;
                this.addFilters((Apply)annotation);
            }
        }
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof Apply)) continue;
            this.addFilters((Apply)annotation);
        }
    }

    private void addFilters(Apply annotation) {
        Class<? extends DuelMvcFilter>[] filters = annotation.value();
        if (filters == null) {
            return;
        }
        for (Class<? extends DuelMvcFilter> filterType : filters) {
            this.addFilter(this.injector.getInstance(filterType));
        }
    }

    private void addFilter(Object value) {
        if (value instanceof AuthFilter) {
            this.authFilters.add((AuthFilter)value);
        }
        if (value instanceof ActionFilter) {
            this.actionFilters.add((ActionFilter)value);
        }
        if (value instanceof ResultFilter) {
            this.resultFilters.add((ResultFilter)value);
        }
        if (value instanceof ErrorFilter) {
            this.errorFilters.add((ErrorFilter)value);
        }
    }
}

