/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.sun.jersey.api.core.ExtendedUriInfo;
import com.sun.jersey.api.model.AbstractResourceMethod;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class UncaughtErrorHandler
implements ExceptionMapper<Throwable> {
    private Provider<ExtendedUriInfo> factory;

    @Inject
    void init_ErrorFilterMapper(Provider<ExtendedUriInfo> factory) {
        this.factory = factory;
    }

    public final Response toResponse(Throwable error) {
        ExtendedUriInfo uriInfo = (ExtendedUriInfo)this.factory.get();
        MediaType resultType = this.getResultType(uriInfo);
        return Response.status((Response.Status)this.getHTTPStatus(uriInfo, error)).entity(this.getResult(uriInfo, error, resultType)).type(resultType).build();
    }

    protected MediaType getResultType(ExtendedUriInfo uriInfo) {
        AbstractResourceMethod method = uriInfo.getMatchedMethod();
        if (method == null) {
            return this.getDefaultMediaType(uriInfo);
        }
        List<MediaType> supportedMediaTypes = this.getSupportedMediaTypes(uriInfo);
        for (MediaType mediaType : method.getSupportedOutputTypes()) {
            if (!supportedMediaTypes.contains(mediaType)) continue;
            return mediaType;
        }
        for (MediaType mediaType : method.getSupportedInputTypes()) {
            if (!supportedMediaTypes.contains(mediaType)) continue;
            return mediaType;
        }
        return this.getDefaultMediaType(uriInfo);
    }

    protected abstract MediaType getDefaultMediaType(ExtendedUriInfo var1);

    protected abstract List<MediaType> getSupportedMediaTypes(ExtendedUriInfo var1);

    protected abstract Response.Status getHTTPStatus(ExtendedUriInfo var1, Throwable var2);

    protected abstract Object getResult(ExtendedUriInfo var1, Throwable var2, MediaType var3);
}

