/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class CrossOriginResourceSharingFilter
implements Filter {
    private final String hostRegExp;
    private final boolean withCredentials;

    public CrossOriginResourceSharingFilter(String hostRegExp, boolean withCredentials) {
        this.hostRegExp = hostRegExp == null || hostRegExp.equals("*") ? null : hostRegExp;
        this.withCredentials = withCredentials;
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String origin = request.getHeader("Origin");
        if (origin == null || origin.isEmpty()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!origin.matches(this.hostRegExp)) {
            response.setStatus(403);
            return;
        }
        response.addHeader("Access-Control-Allow-Origin", this.hostRegExp == null ? "*" : origin);
        if (this.withCredentials) {
            response.addHeader("Access-Control-Allow-Credentials", "true");
        }
        if (request.getHeader("Access-Control-Request-Method") != null && "OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.addHeader("Access-Control-Allow-Methods", "GET,POST,PUT");
            response.addHeader("Access-Control-Allow-Headers", "Cookie");
            response.addHeader("Access-Control-Max-Age", "360");
            response.setStatus(200);
        }
        response.addHeader("Access-Control-Expose-Headers", "Cookie");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

