/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import net.sf.ehcache.constructs.web.filter.GzipFilter;
import org.aopalliance.intercept.MethodInterceptor;
import org.duelengine.duel.mvc.ActionFilterContext;
import org.duelengine.duel.mvc.ActionFilterContextFactory;
import org.duelengine.duel.mvc.ActionFilterInterceptor;
import org.duelengine.duel.mvc.ClassEnumerator;
import org.duelengine.duel.mvc.DefaultWrapperServlet;
import org.duelengine.duel.mvc.NeverExpireFilter;
import org.duelengine.duel.mvc.ResultFilterContext;
import org.duelengine.duel.mvc.ResultFilterContextFactory;
import org.duelengine.duel.mvc.ResultFilterInterceptor;
import org.duelengine.duel.mvc.ViewResult;
import org.duelengine.duel.mvc.ViewResultFactory;

public abstract class DuelMvcModule
extends JerseyServletModule {
    private final HttpServlet defaultServlet = new DefaultWrapperServlet();
    private final Filter neverExpireFilter = new NeverExpireFilter();
    private final Filter gzipFilter = new GzipFilter();

    protected HttpServlet getDefaultServlet() {
        return this.defaultServlet;
    }

    protected Filter getNeverExpireFilter() {
        return this.neverExpireFilter;
    }

    protected Filter getGzipFilter() {
        return this.gzipFilter;
    }

    protected abstract void configureApp();

    protected abstract void bindStaticRoutes();

    protected abstract Package[] getControllerPackages();

    protected void bindControllers() {
        this.bindPackages(this.getControllerPackages());
    }

    private void bindViewResults() {
        this.install(new FactoryModuleBuilder().implement(ViewResult.class, ViewResult.class).build(ViewResultFactory.class));
    }

    private void bindFilterChains() {
        this.install(new FactoryModuleBuilder().implement(ActionFilterContext.class, ActionFilterContext.class).build(ActionFilterContextFactory.class));
        ActionFilterInterceptor actionInterceptor = new ActionFilterInterceptor();
        this.requestInjection(actionInterceptor);
        this.bindInterceptor(Matchers.annotatedWith(Path.class), Matchers.annotatedWith(GET.class).or(Matchers.annotatedWith(POST.class)).or(Matchers.annotatedWith(PUT.class)).or(Matchers.annotatedWith(DELETE.class)).or(Matchers.annotatedWith(HEAD.class)).or(Matchers.annotatedWith(OPTIONS.class)), new MethodInterceptor[]{actionInterceptor});
        this.install(new FactoryModuleBuilder().implement(ResultFilterContext.class, ResultFilterContext.class).build(ResultFilterContextFactory.class));
        ResultFilterInterceptor requestInterceptor = new ResultFilterInterceptor();
        this.requestInjection(requestInterceptor);
        this.bindInterceptor(Matchers.subclassesOf(ViewResult.class), (Matcher)new AbstractMatcher<Method>(){

            public boolean matches(Method m) {
                Class<?>[] paramTypes = m.getParameterTypes();
                return Void.TYPE.equals(m.getReturnType()) && "write".equals(m.getName()) && paramTypes.length == 1 && OutputStream.class.equals(paramTypes[0]);
            }
        }, new MethodInterceptor[]{requestInterceptor});
    }

    private void bindPackages(Package ... packages) {
        if (packages == null) {
            return;
        }
        for (Package pkg : packages) {
            try {
                Set<Class<?>> types = ClassEnumerator.getClasses(pkg.getName());
                for (Class<?> type : types) {
                    if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) continue;
                    this.bind(type);
                }
            }
            catch (Throwable ex) {
                this.addError(ex);
            }
        }
    }

    protected final void configureServlets() {
        try {
            this.configureApp();
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
        try {
            this.bindViewResults();
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
        try {
            this.bindControllers();
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
        try {
            this.bindFilterChains();
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
        try {
            this.bindStaticRoutes();
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
        try {
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
        catch (Throwable ex) {
            this.addError(ex);
        }
    }
}

