/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.util.LinkedHashMap;
import java.util.Map;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.JSUtility;

public class SparseMap
extends LinkedHashMap<String, Object> {
    public SparseMap() {
    }

    public SparseMap(int initialCapacity) {
        super(initialCapacity);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object putSparse(String ident, Object value) {
        if (ident == null) {
            throw new NullPointerException("ident");
        }
        if (!JSUtility.isValidIdentifier(ident, true)) {
            return this.put(ident, value);
        }
        SparseMap parent = this;
        int prevDot = -1;
        int nextDot = ident.indexOf(46);
        while (nextDot > prevDot) {
            void var7_7;
            String childKey = ident.substring(prevDot + 1, nextDot);
            if (parent.containsKey(childKey)) {
                Object obj = parent.get(childKey);
                if (!(obj instanceof Map)) throw new IllegalArgumentException("Object cannot have properties: " + ident);
                Map map = (Map)obj;
            } else {
                SparseMap sparseMap = new SparseMap();
                parent.put(childKey, sparseMap);
            }
            parent = var7_7;
            prevDot = nextDot;
            nextDot = ident.indexOf(46, nextDot + 1);
        }
        return parent.put(ident.substring(prevDot + 1), DuelData.asProxy(value, false));
    }

    public static SparseMap asSparseMap(Object ... pairs) {
        if (pairs == null || pairs.length < 1) {
            return new SparseMap(0);
        }
        int length = pairs.length / 2;
        SparseMap map = new SparseMap(length + 2);
        for (int i = 0; i < length; ++i) {
            String key = DuelData.coerceString(pairs[2 * i]);
            Object value = pairs[2 * i + 1];
            map.putSparse(key, value);
        }
        return map;
    }
}

