/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.duelengine.duel.LinkInterceptor;

public class CDNLinkInterceptor
implements LinkInterceptor {
    private final boolean isDevMode;
    private final String cdnHost;
    private final Map<String, String> cdnMap;

    public CDNLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, boolean isDevMode) throws URISyntaxException {
        this(cdnHost, CDNLinkInterceptor.bundleAsMap(cdnBundle), isDevMode);
    }

    public CDNLinkInterceptor(String cdnHost, Map<String, String> cdnMap, boolean isDevMode) throws URISyntaxException {
        this.isDevMode = isDevMode;
        this.cdnMap = cdnMap;
        this.cdnHost = cdnHost == null || cdnHost.isEmpty() ? "" : new URI("http", cdnHost, null, null).getRawSchemeSpecificPart();
        Logger log = Logger.getLogger(CDNLinkInterceptor.class.getCanonicalName());
        log.config("cdnHost=" + this.cdnHost);
        log.config("isDevModet=" + this.isDevMode);
    }

    @Override
    public String transformURL(String url) {
        if (!this.cdnMap.containsKey(url)) {
            return url;
        }
        String cdnURL = this.cdnMap.get(url);
        if (this.isDevMode) {
            if (!this.cdnMap.containsKey(cdnURL)) {
                return url;
            }
            cdnURL = this.cdnMap.get(cdnURL);
        }
        return this.cdnHost + cdnURL;
    }

    private static Map<String, String> bundleAsMap(ResourceBundle cdnBundle) {
        Set<String> keys = cdnBundle.keySet();
        HashMap<String, String> cdnMap = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            cdnMap.put(key, cdnBundle.getString(key));
        }
        return cdnMap;
    }
}

