/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duelengine.duel.ArrayIterable;
import org.duelengine.duel.ProxyMap;
import org.duelengine.duel.SingleIterable;

public final class DuelData {
    private static final Double ZERO = 0.0;
    private static final Double NaN = Double.NaN;

    private DuelData() {
    }

    public static Map<String, Object> asMap(Object ... pairs) {
        if (pairs == null || pairs.length < 1) {
            return new LinkedHashMap<String, Object>(0);
        }
        int length = pairs.length / 2;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(length + 2);
        for (int i = 0; i < length; ++i) {
            String key = DuelData.coerceString(pairs[2 * i]);
            Object value = pairs[2 * i + 1];
            map.put(key, value);
        }
        return map;
    }

    public static <T> List<T> asList(T ... items) {
        if (items == null || items.length < 1) {
            return new ArrayList(0);
        }
        return Arrays.asList(items);
    }

    public static boolean isPrimitive(Class<?> dataType) {
        return dataType.isPrimitive() || String.class.equals(dataType) || Number.class.isAssignableFrom(dataType) || Date.class.equals(dataType) || Boolean.class.equals(dataType) || Character.class.isAssignableFrom(dataType);
    }

    public static boolean isBoolean(Class<?> exprType) {
        return Boolean.class.equals(exprType) || Boolean.TYPE.equals(exprType);
    }

    public static boolean isNumber(Class<?> exprType) {
        return Number.class.isAssignableFrom(exprType) || Integer.TYPE.isAssignableFrom(exprType) || Double.TYPE.isAssignableFrom(exprType) || Float.TYPE.isAssignableFrom(exprType) || Long.TYPE.isAssignableFrom(exprType) || Short.TYPE.isAssignableFrom(exprType) || Byte.TYPE.isAssignableFrom(exprType) || BigInteger.class.isAssignableFrom(exprType) || BigDecimal.class.isAssignableFrom(exprType);
    }

    public static boolean isString(Class<?> exprType) {
        return String.class.equals(exprType);
    }

    public static boolean isArray(Class<?> exprType) {
        return exprType.isArray() || Iterable.class.isAssignableFrom(exprType);
    }

    public static boolean coerceBoolean(Object data) {
        if (data == null || Boolean.FALSE.equals(data) || "".equals(data)) {
            return false;
        }
        if (data instanceof Number) {
            return !ZERO.equals(data = Double.valueOf(((Number)data).doubleValue())) && !NaN.equals(data);
        }
        return true;
    }

    public static double coerceNumber(Object data) {
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data instanceof Boolean) {
            return (Boolean)data != false ? 1.0 : 0.0;
        }
        return DuelData.coerceBoolean(data) ? Double.NaN : 0.0;
    }

    public static String coerceString(Object data) {
        if (data == null) {
            return "";
        }
        Class<?> dataType = data.getClass();
        if (String.class.equals(dataType)) {
            return (String)data;
        }
        if (Date.class.equals(dataType)) {
            return String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL %1$tz", data);
        }
        if (DuelData.isNumber(dataType)) {
            double number = ((Number)data).doubleValue();
            if (number == (double)((long)number)) {
                return Long.toString((long)number);
            }
            return Double.toString(number);
        }
        if (Iterable.class.isAssignableFrom(dataType)) {
            StringBuilder buffer = new StringBuilder();
            boolean needsDelim = false;
            for (Object item : (Iterable)data) {
                if (needsDelim) {
                    buffer.append(", ");
                } else {
                    needsDelim = true;
                }
                buffer.append(DuelData.coerceString(item));
            }
            return buffer.toString();
        }
        if (dataType.isArray()) {
            StringBuilder buffer = new StringBuilder();
            boolean needsDelim = false;
            int length = Array.getLength(data);
            for (int i = 0; i < length; ++i) {
                if (needsDelim) {
                    buffer.append(", ");
                } else {
                    needsDelim = true;
                }
                buffer.append(DuelData.coerceString(Array.get(data, i)));
            }
            return buffer.toString();
        }
        if (Map.class.isAssignableFrom(dataType)) {
            Map map = (Map)data;
            Iterator iterator = map.entrySet().iterator();
            StringBuilder buffer = new StringBuilder().append('{');
            boolean needsDelim = false;
            while (iterator.hasNext()) {
                if (needsDelim) {
                    buffer.append(", ");
                } else {
                    needsDelim = true;
                }
                Map.Entry entry = iterator.next();
                buffer.append(DuelData.coerceString(entry.getKey())).append('=').append(DuelData.coerceString(entry.getValue()));
            }
            return buffer.append('}').toString();
        }
        return data.toString();
    }

    public static Collection<?> coerceCollection(Object data) {
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        Class<?> dataType = data.getClass();
        if (Collection.class.isAssignableFrom(dataType)) {
            return (Collection)data;
        }
        if (dataType.isArray()) {
            return new ArrayIterable(data);
        }
        if (Iterable.class.isAssignableFrom(dataType)) {
            LinkedList list = new LinkedList();
            for (Object item : (Iterable)data) {
                list.add(item);
            }
            return list;
        }
        return new SingleIterable(data);
    }

    public static Map<?, ?> coerceMap(Object data) {
        if (data == null) {
            return Collections.EMPTY_MAP;
        }
        Class<?> dataType = data.getClass();
        if (Map.class.isAssignableFrom(dataType)) {
            return (Map)data;
        }
        if (DuelData.isPrimitive(dataType)) {
            return DuelData.asMap("", data);
        }
        if (DuelData.isArray(dataType)) {
            int i = 0;
            Collection<?> array = DuelData.coerceCollection(data);
            LinkedHashMap map = new LinkedHashMap(array.size());
            for (Object item : array) {
                map.put(Integer.toString(i++), item);
            }
            return map;
        }
        return new ProxyMap(data, true);
    }

    static Object asProxy(Object data, boolean readonly) {
        if (data == null) {
            return null;
        }
        Class<?> dataType = data.getClass();
        if (DuelData.isPrimitive(dataType) || DuelData.isArray(dataType) || Map.class.isAssignableFrom(dataType)) {
            return data;
        }
        return new ProxyMap(data, readonly);
    }
}

