/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class JSUtility {
    private static final String CONFIG_RESOURCE = "org.duelengine.duel.JSUtility";
    private static Map<String, Boolean> reserved;
    private static Map<String, Boolean> globals;
    private static Map<String, Boolean> properties;
    private static Map<String, Boolean> browser;
    private static boolean inited;

    private JSUtility() {
    }

    public static boolean isValidIdentifier(String ident, boolean nested) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        if (nested) {
            String[] parts = ident.split(".");
            int length = parts.length;
            for (int i = 0; i < length; ++i) {
                if (!JSUtility.isValidIdentifier(parts[i], false)) {
                    return false;
                }
                if (i != 0 || !globals.containsKey(parts[i])) continue;
                return false;
            }
            return true;
        }
        if (reserved.containsKey(ident)) {
            return false;
        }
        boolean indentPart = false;
        int length = ident.length();
        for (int i = 0; i < length; ++i) {
            char ch = ident.charAt(i);
            if (indentPart && ch >= '0' && ch <= '9') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$') {
                indentPart = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isGlobalIdent(String ident) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        return globals.containsKey(ident) || browser.containsKey(ident);
    }

    public static boolean isObjectProperty(String ident) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        return properties.containsKey(ident);
    }

    private static void initLookups() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        String[] tags = config != null && config.containsKey("reserved") ? config.getString("reserved").split(",") : new String[]{};
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(tags.length);
        for (String value : tags) {
            map.put(value, true);
        }
        for (String value : tags = config != null && config.containsKey("properties") ? config.getString("properties").split(",") : new String[]{}) {
            map.put(value, true);
        }
        reserved = map;
        tags = config != null && config.containsKey("globals") ? config.getString("globals").split(",") : new String[]{};
        map = new HashMap(tags.length);
        for (String value : tags) {
            map.put(value, true);
        }
        globals = map;
        tags = config != null && config.containsKey("properties") ? config.getString("properties").split(",") : new String[]{};
        map = new HashMap(tags.length);
        for (String value : tags) {
            map.put(value, true);
        }
        properties = map;
        tags = config != null && config.containsKey("browser") ? config.getString("browser").split(",") : new String[]{};
        map = new HashMap(tags.length);
        for (String value : tags) {
            map.put(value, true);
        }
        browser = map;
    }
}

