/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.duelengine.duel.LinkInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDNLinkInterceptor
implements LinkInterceptor {
    private final boolean isDevMode;
    private final String cdnHost;
    private final Map<String, String> cdnMap;

    public CDNLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, boolean isDevMode) throws URISyntaxException {
        this(cdnHost, CDNLinkInterceptor.bundleAsMap(cdnBundle, isDevMode), isDevMode);
    }

    public CDNLinkInterceptor(String cdnHost, Map<String, String> cdnMap, boolean isDevMode) throws URISyntaxException {
        this.isDevMode = isDevMode;
        this.cdnMap = cdnMap;
        this.cdnHost = cdnHost == null || cdnHost.isEmpty() ? "" : new URI("http", cdnHost, null, null).getRawSchemeSpecificPart();
        Logger log = LoggerFactory.getLogger(CDNLinkInterceptor.class);
        log.info("cdnHost=" + this.cdnHost);
        log.info("isDevModet=" + this.isDevMode);
    }

    @Override
    public String transformURL(String url) {
        if (!this.cdnMap.containsKey(url)) {
            return url;
        }
        String cdnURL = this.cdnMap.get(url);
        if (this.isDevMode) {
            if (!this.cdnMap.containsKey(cdnURL)) {
                return url;
            }
            cdnURL = this.cdnMap.get(cdnURL);
        }
        return this.cdnHost + cdnURL;
    }

    private static Map<String, String> bundleAsMap(final ResourceBundle bundle, boolean isDevMode) {
        if (!isDevMode) {
            Set<String> keys = bundle.keySet();
            HashMap<String, String> map = new HashMap<String, String>(keys.size());
            for (String key : keys) {
                map.put(key, bundle.getString(key));
            }
            return map;
        }
        return new Map<String, String>(){

            @Override
            public void clear() {
            }

            @Override
            public boolean containsKey(Object arg0) {
                return bundle.containsKey((String)arg0);
            }

            @Override
            public boolean containsValue(Object arg0) {
                return false;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return null;
            }

            @Override
            public String get(Object arg0) {
                return (String)bundle.getObject((String)arg0);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public String put(String arg0, String arg1) {
                return null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> arg0) {
            }

            @Override
            public String remove(Object arg0) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Collection<String> values() {
                return null;
            }
        };
    }
}

