/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.JSUtility;
import org.duelengine.duel.SparseMap;

public class DataEncoder {
    private static final DateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final boolean prettyPrint;
    private final String indent;
    private final String newline;

    public static Snippet asSnippet(String text) {
        return new Snippet(text);
    }

    public DataEncoder() {
        this(null, null);
    }

    public DataEncoder(String newline, String indent) {
        this.newline = newline != null ? newline : "";
        this.indent = indent != null ? indent : "";
        this.prettyPrint = this.indent.length() > 0 || this.newline.length() > 0;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public String encode(Object data) {
        StringBuilder buffer = new StringBuilder();
        try {
            this.write(buffer, data, EncodingFormat.ECMASCRIPT, 0);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return buffer.toString();
    }

    public String encodeJSON(Object data) {
        StringBuilder buffer = new StringBuilder();
        try {
            this.write(buffer, data, EncodingFormat.JSON, 0);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return buffer.toString();
    }

    public void writeJSON(Appendable output, Object data) throws IOException {
        this.write(output, data, EncodingFormat.JSON, 0);
    }

    public void write(Appendable output, Object data) throws IOException {
        if (data instanceof SparseMap) {
            return;
        }
        this.write(output, data, EncodingFormat.ECMASCRIPT, 0);
    }

    public void write(Appendable output, Object data, int depth) throws IOException {
        this.write(output, data, EncodingFormat.ECMASCRIPT, depth);
    }

    private void write(Appendable output, Object data, EncodingFormat format, int depth) throws IOException {
        Class<?> dataType;
        if (data == null) {
            output.append("null");
            return;
        }
        if (format == null) {
            format = EncodingFormat.ECMASCRIPT;
        }
        if (Snippet.class.equals(dataType = data.getClass())) {
            output.append(((Snippet)data).getSnippet());
        } else if (String.class.equals(dataType)) {
            this.writeString(output, (String)data, format);
        } else if (DuelData.isNumber(dataType)) {
            this.writeNumber(output, data, format);
        } else if (DuelData.isBoolean(dataType)) {
            this.writeBoolean(output, DuelData.coerceBoolean(data), format);
        } else if (DuelData.isArray(dataType)) {
            this.writeArray(output, DuelData.coerceCollection(data), format, depth);
        } else if (Date.class.equals(dataType)) {
            this.writeDate(output, (Date)data, format);
        } else {
            this.writeObject(output, DuelData.coerceMap(data), format, depth);
        }
    }

    private void writeBoolean(Appendable output, boolean data, EncodingFormat format) throws IOException {
        output.append(data ? "true" : "false");
    }

    private void writeNumber(Appendable output, Object data, EncodingFormat format) throws IOException {
        double number = ((Number)data).doubleValue();
        Class<?> dataType = data.getClass();
        if (Long.class.equals(dataType) || Long.TYPE.equals(dataType)) {
            long numberLong = ((Number)data).longValue();
            if (DataEncoder.invalidIEEE754(numberLong)) {
                this.writeString(output, Long.toString(numberLong), format);
            } else {
                output.append(Long.toString(numberLong));
            }
        } else if (number == (double)((long)number)) {
            output.append(Long.toString((long)number));
        } else {
            output.append(Double.toString(number));
        }
    }

    private void writeDate(Appendable output, Date data, EncodingFormat format) throws IOException {
        if (format == EncodingFormat.ECMASCRIPT) {
            output.append("new Date(");
            output.append(Long.toString(data.getTime()));
            output.append(")");
        } else {
            this.writeString(output, ISO8601.format(data), format);
        }
    }

    private void writeArray(Appendable output, Collection<?> data, EncodingFormat format, int depth) throws IOException {
        boolean singleAttr;
        output.append('[');
        ++depth;
        boolean hasChildren = singleAttr = data.size() == 1;
        boolean needsDelim = false;
        for (Object item : data) {
            if (data instanceof SparseMap) continue;
            if (singleAttr) {
                if (this.prettyPrint) {
                    output.append(' ');
                }
            } else {
                if (needsDelim) {
                    output.append(',');
                } else {
                    needsDelim = true;
                    hasChildren = true;
                }
                if (this.prettyPrint) {
                    this.writeln(output, depth);
                }
            }
            this.write(output, item, format, depth);
        }
        --depth;
        if (this.prettyPrint) {
            if (singleAttr) {
                output.append(' ');
            } else if (hasChildren) {
                this.writeln(output, depth);
            }
        }
        output.append(']');
    }

    private void writeObject(Appendable output, Map<?, ?> data, EncodingFormat format, int depth) throws IOException {
        boolean singleAttr;
        output.append('{');
        ++depth;
        Set<Map.Entry<?, ?>> properties = data.entrySet();
        boolean hasChildren = singleAttr = properties.size() == 1;
        boolean needsDelim = false;
        for (Map.Entry<?, ?> property : properties) {
            Object value = property.getValue();
            if (value instanceof SparseMap) continue;
            if (singleAttr) {
                if (this.prettyPrint) {
                    output.append(' ');
                }
            } else {
                if (needsDelim) {
                    output.append(',');
                } else {
                    needsDelim = true;
                    hasChildren = true;
                }
                if (this.prettyPrint) {
                    this.writeln(output, depth);
                }
            }
            this.writePropertyName(output, property.getKey(), format);
            if (this.prettyPrint) {
                output.append(" : ");
            } else {
                output.append(':');
            }
            this.write(output, value, format, depth);
        }
        --depth;
        if (this.prettyPrint) {
            if (singleAttr) {
                output.append(' ');
            } else if (hasChildren) {
                this.writeln(output, depth);
            }
        }
        output.append('}');
    }

    private void writePropertyName(Appendable output, Object data, EncodingFormat format) throws IOException {
        String name = DuelData.coerceString(data);
        if (format == EncodingFormat.ECMASCRIPT && JSUtility.isValidIdentifier(name, false)) {
            output.append(name);
        } else {
            this.writeString(output, name, format);
        }
    }

    private void writeString(Appendable output, String data, EncodingFormat format) throws IOException {
        if (data == null) {
            output.append("null");
            return;
        }
        int start = 0;
        int length = data.length();
        if (format == EncodingFormat.JSON) {
            output.append('\"');
        } else {
            output.append('\'');
        }
        block10: for (int i = start; i < length; ++i) {
            String escape;
            char ch = data.charAt(i);
            switch (ch) {
                case '\'': {
                    if (format == EncodingFormat.JSON) continue block10;
                    escape = "\\'";
                    break;
                }
                case '\"': {
                    if (format != EncodingFormat.JSON) continue block10;
                    escape = "\\\"";
                    break;
                }
                case '\\': {
                    escape = "\\\\";
                    break;
                }
                case '\t': {
                    escape = "\\t";
                    break;
                }
                case '\n': {
                    escape = "\\n";
                    break;
                }
                case '\r': {
                    escape = "\\r";
                    break;
                }
                case '\f': {
                    escape = "\\f";
                    break;
                }
                case '\b': {
                    escape = "\\b";
                    break;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') continue block10;
                    escape = String.format("\\u%04X", data.codePointAt(i));
                }
            }
            if (i > start) {
                output.append(data, start, i);
            }
            start = i + 1;
            output.append(escape);
        }
        if (length > start) {
            output.append(data, start, length);
        }
        if (format == EncodingFormat.JSON) {
            output.append('\"');
        } else {
            output.append('\'');
        }
    }

    public boolean writeNamespace(Appendable output, List<String> namespaces, String ident) throws IOException {
        if (!JSUtility.isValidIdentifier(ident, true)) {
            throw new IllegalArgumentException("Invalid identifier: " + ident);
        }
        boolean wroteNS = false;
        boolean isRoot = true;
        int nextDot = ident.indexOf(46);
        while (nextDot > -1) {
            String ns = ident.substring(0, nextDot);
            if (isRoot && JSUtility.isGlobalIdent(ns) || namespaces.contains(ns)) {
                nextDot = ident.indexOf(46, nextDot + 1);
                isRoot = false;
                continue;
            }
            namespaces.add(ns);
            if (isRoot) {
                output.append("var ");
                isRoot = false;
            }
            output.append(ns);
            if (this.prettyPrint) {
                output.append(' ');
            }
            output.append('=');
            if (this.prettyPrint) {
                output.append(' ');
            }
            output.append(ns);
            if (this.prettyPrint) {
                output.append(' ');
            }
            output.append("||");
            if (this.prettyPrint) {
                output.append(' ');
            }
            output.append("{};");
            nextDot = ident.indexOf(46, nextDot + 1);
            this.writeln(output, 0);
            wroteNS = true;
        }
        return wroteNS;
    }

    @Deprecated
    public void writeNamespaceAlt(Appendable output, List<String> namespaces, String ident) throws IOException {
        if (!JSUtility.isValidIdentifier(ident, true)) {
            throw new IllegalArgumentException("Invalid identifier: " + ident);
        }
        boolean needsNewline = false;
        boolean isRoot = true;
        int nextDot = ident.indexOf(46);
        while (nextDot > -1) {
            String ns = ident.substring(0, nextDot);
            if (isRoot && JSUtility.isGlobalIdent(ns) || namespaces.contains(ns)) {
                nextDot = ident.indexOf(46, nextDot + 1);
                isRoot = false;
                continue;
            }
            namespaces.add(ns);
            if (isRoot) {
                this.writeln(output, 0);
                output.append("var ");
                output.append(ns);
                output.append(';');
                isRoot = false;
            }
            this.writeln(output, 0);
            output.append("if (typeof ");
            output.append(ns);
            output.append(" === 'undefined') {");
            this.writeln(output, 1);
            output.append(ns);
            output.append(" = {};");
            this.writeln(output, 0);
            output.append('}');
            nextDot = ident.indexOf(46, nextDot + 1);
            needsNewline = true;
        }
        if (needsNewline) {
            this.writeln(output, 0);
        }
    }

    public void indent(Appendable output, int depth) throws IOException {
        while (depth-- > 0) {
            output.append(this.indent);
        }
    }

    public void writeln(Appendable output, int depth) throws IOException {
        output.append(this.newline);
        while (depth-- > 0) {
            output.append(this.indent);
        }
    }

    private static boolean invalidIEEE754(long value) {
        if (Long.MAX_VALUE == value || Long.MIN_VALUE == value) {
            return true;
        }
        try {
            return (long)((double)value) != value;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public void writeVars(Appendable output, SparseMap items) throws IOException {
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        this.accumulateVars(items, vars, new StringBuilder());
        ArrayList<String> namespaces = new ArrayList<String>();
        for (Map.Entry externalVar : vars.entrySet()) {
            String key = (String)externalVar.getKey();
            this.writeNamespace(output, namespaces, key);
            if (key.indexOf(46) < 0) {
                output.append("var ");
            }
            output.append(key);
            if (this.prettyPrint) {
                output.append(' ');
            }
            output.append('=');
            if (this.prettyPrint) {
                output.append(' ');
            }
            this.write(output, externalVar.getValue());
            output.append(';');
            this.writeln(output, 0);
        }
    }

    private void accumulateVars(Object data, Map<String, Object> vars, StringBuilder buffer) throws IOException {
        block10: {
            Class<?> dataType;
            boolean emptyBuffer;
            int length;
            block9: {
                if (data == null) {
                    return;
                }
                String ROOT = "window";
                length = buffer.length();
                emptyBuffer = length < 1;
                dataType = data.getClass();
                if (!Map.class.isAssignableFrom(dataType)) break block9;
                boolean isSparseMap = SparseMap.class.equals(dataType);
                for (Map.Entry child : ((Map)data).entrySet()) {
                    String key = DuelData.coerceString(child.getKey());
                    if (JSUtility.isValidIdentifier(key, false)) {
                        if (!emptyBuffer) {
                            buffer.append('.');
                        }
                        buffer.append(key);
                    } else {
                        if (emptyBuffer) {
                            buffer.append("window");
                        }
                        buffer.append('[');
                        this.writeString(buffer, key, EncodingFormat.ECMASCRIPT);
                        buffer.append(']');
                    }
                    Object value = child.getValue();
                    if (isSparseMap && !(value instanceof SparseMap)) {
                        vars.put(buffer.toString(), value);
                    }
                    this.accumulateVars(value, vars, buffer);
                    buffer.setLength(length);
                }
                break block10;
            }
            if (!DuelData.isArray(dataType)) break block10;
            int i = 0;
            for (Object child : DuelData.coerceCollection(data)) {
                if (emptyBuffer) {
                    buffer.append("window");
                }
                buffer.append('[');
                this.writeNumber(buffer, i++, EncodingFormat.ECMASCRIPT);
                buffer.append(']');
                this.accumulateVars(child, vars, buffer);
                buffer.setLength(length);
            }
        }
    }

    static {
        ISO8601.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static enum EncodingFormat {
        ECMASCRIPT,
        JSON;

    }

    public static class Snippet {
        private final String snippet;

        public Snippet(String snippet) {
            this.snippet = snippet;
        }

        public String getSnippet() {
            return this.snippet;
        }
    }
}

