/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.io.IOException;

public class HTMLFormatter {
    public HTMLFormatter writeComment(Appendable output, String value) throws IOException {
        String OPEN = "<!--";
        String CLOSE = "-->";
        output.append("<!--");
        if (value != null) {
            int start = 0;
            int length = value.length();
            int close = value.indexOf("-->");
            while (close >= 0) {
                output.append(value, start, close + 2).append("&gt;");
                start = close + 3;
                close = value.indexOf("-->", start);
            }
            if (start < length) {
                output.append(value, start, length);
            }
        }
        output.append("-->");
        return this;
    }

    public HTMLFormatter writeDocType(Appendable output, String value) throws IOException {
        String OPEN = "<!DOCTYPE";
        int CLOSE = 62;
        output.append("<!DOCTYPE");
        if (value != null && value.length() > 0) {
            output.append(' ').append(value);
        }
        output.append('>');
        return this;
    }

    public HTMLFormatter writeOpenElementBeginTag(Appendable output, String tagName) throws IOException {
        output.append('<').append(tagName);
        return this;
    }

    public HTMLFormatter writeOpenAttribute(Appendable output, String name) throws IOException {
        output.append(' ').append(name).append("=\"");
        return this;
    }

    public HTMLFormatter writeCloseAttribute(Appendable output) throws IOException {
        output.append('\"');
        return this;
    }

    public HTMLFormatter writeAttribute(Appendable output, String name, String value) throws IOException {
        output.append(' ').append(name);
        if (value != null) {
            output.append("=\"");
            this.writeLiteral(output, value, true, true);
            output.append('\"');
        }
        return this;
    }

    public HTMLFormatter writeCloseElementBeginTag(Appendable output) throws IOException {
        output.append('>');
        return this;
    }

    public HTMLFormatter writeCloseElementVoidTag(Appendable output) throws IOException {
        output.append(" />");
        return this;
    }

    public HTMLFormatter writeElementEndTag(Appendable output, String tagName) throws IOException {
        output.append("</").append(tagName).append('>');
        return this;
    }

    public HTMLFormatter writeLiteral(Appendable output, String value) throws IOException {
        return this.writeLiteral(output, value, false, false);
    }

    public HTMLFormatter writeLiteral(Appendable output, String value, boolean encodeNonASCII) throws IOException {
        return this.writeLiteral(output, value, false, encodeNonASCII);
    }

    private HTMLFormatter writeLiteral(Appendable output, String value, boolean isAttribute, boolean encodeNonASCII) throws IOException {
        if (value == null) {
            return this;
        }
        int start = 0;
        int length = value.length();
        block16: for (int i = start; i < length; ++i) {
            String entity;
            char ch = value.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    if (!isAttribute) continue block16;
                    entity = String.format("&#x%04X", value.codePointAt(i));
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\"': {
                    if (!isAttribute) continue block16;
                    entity = "&quot;";
                    break;
                }
                case '\u00a0': {
                    entity = "&nbsp;";
                    break;
                }
                case '\u00a9': {
                    entity = "&copy;";
                    break;
                }
                case '\u2122': {
                    entity = "&trade;";
                    break;
                }
                case '\u00ae': {
                    entity = "&reg;";
                    break;
                }
                case '\u00e9': {
                    entity = "&eacute;";
                    break;
                }
                case '\u2026': {
                    entity = "&hellip;";
                    break;
                }
                case '\u00ad': {
                    entity = "&shy;";
                    break;
                }
                case '\u00b7': {
                    entity = "&middot;";
                    break;
                }
                case '\u2022': {
                    entity = "&bull;";
                    break;
                }
                default: {
                    if (ch >= ' ' && (ch < '\u007f' || !encodeNonASCII && ch > '\u0084') && (ch < '\u0086' || ch > '\u009f') && (ch < '\ufdd0' || ch > '\ufdef')) continue block16;
                    entity = String.format("&#x%04X;", value.codePointAt(i));
                }
            }
            if (i > start) {
                output.append(value, start, i);
            }
            start = i + 1;
            output.append(entity);
        }
        if (length > start) {
            if (start == 0) {
                output.append(value);
            } else {
                output.append(value, start, length);
            }
        }
        return this;
    }
}

