/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public final class JSUtility {
    private static final String CONFIG_RESOURCE = "org.duelengine.duel.JSUtility";
    private static Set<String> reserved;
    private static Set<String> globals;
    private static Set<String> properties;
    private static Set<String> browser;
    private static boolean inited;

    private JSUtility() {
    }

    public static boolean isValidIdentifier(String ident, boolean nested) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        if (nested) {
            String[] parts = ident.split(".");
            int length = parts.length;
            for (int i = 0; i < length; ++i) {
                if (!JSUtility.isValidIdentifier(parts[i], false)) {
                    return false;
                }
                if (i != 0 || !globals.contains(parts[i])) continue;
                return false;
            }
            return true;
        }
        if (reserved.contains(ident)) {
            return false;
        }
        boolean indentPart = false;
        int length = ident.length();
        for (int i = 0; i < length; ++i) {
            char ch = ident.charAt(i);
            if (indentPart && ch >= '0' && ch <= '9') continue;
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$') {
                indentPart = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isGlobalIdent(String ident) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        return globals.contains(ident) || browser.contains(ident);
    }

    public static boolean isObjectProperty(String ident) {
        if (ident == null || ident.isEmpty()) {
            return false;
        }
        if (!inited) {
            JSUtility.initLookups();
        }
        return properties.contains(ident);
    }

    private static void initLookups() {
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE, Locale.ROOT);
        String[] tags = config != null && config.containsKey("reserved") ? config.getString("reserved").split(",") : new String[]{};
        HashSet<String> set = new HashSet<String>(tags.length);
        for (String value : tags) {
            set.add(value);
        }
        for (String value : tags = config != null && config.containsKey("properties") ? config.getString("properties").split(",") : new String[]{}) {
            set.add(value);
        }
        reserved = set;
        tags = config != null && config.containsKey("globals") ? config.getString("globals").split(",") : new String[]{};
        set = new HashSet(tags.length);
        for (String value : tags) {
            set.add(value);
        }
        globals = set;
        tags = config != null && config.containsKey("properties") ? config.getString("properties").split(",") : new String[]{};
        set = new HashSet(tags.length);
        for (String value : tags) {
            set.add(value);
        }
        properties = set;
        tags = config != null && config.containsKey("browser") ? config.getString("browser").split(",") : new String[]{};
        set = new HashSet(tags.length);
        for (String value : tags) {
            set.add(value);
        }
        browser = set;
    }
}

