/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.util.AbstractList;
import java.util.Iterator;

class SingleIterable
extends AbstractList<Object> {
    private final Object value;

    public SingleIterable(Object proxyValue) {
        this.value = proxyValue;
    }

    @Override
    public Iterator<Object> iterator() {
        return new SingleIterator(this.value);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.value};
    }

    @Override
    public Object get(int index) {
        if (index != 0) {
            return null;
        }
        return this.value;
    }

    @Override
    public int indexOf(Object val) {
        return this.value == val ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object val) {
        return this.indexOf(val);
    }

    private class SingleIterator
    implements Iterator<Object> {
        private final Object value;
        private boolean consumed;

        public SingleIterator(Object proxyValue) {
            this.value = proxyValue;
        }

        @Override
        public boolean hasNext() {
            return !this.consumed;
        }

        @Override
        public Object next() {
            if (this.consumed) {
                return null;
            }
            this.consumed = true;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

