/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.duelengine.duel.LinkInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDNLinkInterceptor
implements LinkInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CDNLinkInterceptor.class);
    protected final boolean isDevMode;
    protected final String cdnHost;
    private final Map<String, String> cdnMap;

    public CDNLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, boolean isDevMode) throws URISyntaxException {
        this(cdnHost, CDNLinkInterceptor.bundleAsMap(cdnBundle, isDevMode), isDevMode);
    }

    public CDNLinkInterceptor(String cdnHost, Map<String, String> cdnMap, boolean isDevMode) throws URISyntaxException {
        if (cdnMap == null) {
            cdnMap = Collections.emptyMap();
        }
        this.isDevMode = isDevMode;
        this.cdnMap = cdnMap;
        this.cdnHost = CDNLinkInterceptor.formatURL(cdnHost);
        log.info("cdnHost=" + cdnHost);
        log.info("isDevMode=" + isDevMode);
    }

    private static String formatURL(String path) {
        String string = path = path == null ? "" : path.trim();
        if (path.isEmpty() || path.equals("/")) {
            return "";
        }
        if (!path.startsWith(".")) {
            try {
                int index = path.indexOf(47);
                path = index < 0 ? new URI("http", path, null, null).getRawSchemeSpecificPart() : new URI("http", path.substring(0, index), path.substring(index), null).getRawSchemeSpecificPart();
            }
            catch (URISyntaxException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            if (!path.startsWith("/")) {
                path = "//" + path;
            }
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public String transformURL(String url) {
        int hash;
        String suffix = "";
        int query = url.indexOf(63);
        if (query >= 0) {
            suffix = suffix + url.substring(query);
            url = url.substring(0, query);
        }
        if ((hash = url.indexOf(35)) >= 0) {
            suffix = suffix + url.substring(hash);
            url = url.substring(0, hash);
        }
        if (!this.cdnMap.containsKey(url)) {
            return url + suffix;
        }
        String cdnURL = this.cdnMap.get(url);
        if (this.isDevMode) {
            if (!this.cdnMap.containsKey(cdnURL)) {
                return url + suffix;
            }
            cdnURL = this.cdnMap.get(cdnURL);
        }
        return this.cdnHost + cdnURL + suffix;
    }

    protected static Map<String, String> bundleAsMap(final ResourceBundle bundle, boolean isDevMode) {
        if (bundle == null) {
            return null;
        }
        if (!isDevMode) {
            Set<String> keys = bundle.keySet();
            HashMap<String, String> map = new HashMap<String, String>(keys.size());
            for (String key : keys) {
                map.put(key, bundle.getString(key));
            }
            return map;
        }
        return new Map<String, String>(){

            @Override
            public void clear() {
            }

            @Override
            public boolean containsKey(Object arg0) {
                return bundle.containsKey((String)arg0);
            }

            @Override
            public boolean containsValue(Object arg0) {
                return false;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return null;
            }

            @Override
            public String get(Object arg0) {
                return (String)bundle.getObject((String)arg0);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Set<String> keySet() {
                return null;
            }

            @Override
            public String put(String arg0, String arg1) {
                return null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> arg0) {
            }

            @Override
            public String remove(Object arg0) {
                return null;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Collection<String> values() {
                return null;
            }
        };
    }
}

