/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duelengine.duel.DataEncoder;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.DuelPart;
import org.duelengine.duel.HTMLFormatter;
import org.duelengine.duel.JSUtility;

public abstract class DuelView {
    private static final int DEFAULT_INDEX = 0;
    private static final int DEFAULT_COUNT = 1;
    private static final String DEFAULT_KEY = null;
    private static final HTMLFormatter formatter = new HTMLFormatter();
    private Map<String, DuelPart> parts = null;

    protected DuelView() {
        this.init();
    }

    protected DuelView(DuelPart ... viewParts) {
        this.init();
        if (viewParts != null && viewParts.length > 0) {
            if (this.parts == null) {
                this.parts = new HashMap<String, DuelPart>(viewParts.length);
            }
            for (DuelPart part : viewParts) {
                if (part == null || part.getPartName() == null) continue;
                this.parts.put(part.getPartName(), part);
            }
        }
    }

    protected void init() {
    }

    public void render(Appendable output) throws IOException {
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.render(new DuelContext().setOutput(output));
    }

    public void render(Appendable output, Object data) throws IOException {
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.render(new DuelContext().setOutput(output).setData(data));
    }

    public void render(DuelContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.render(context, DuelData.asProxy(context.getData(), true), 0, 1, DEFAULT_KEY);
    }

    protected abstract void render(DuelContext var1, Object var2, int var3, int var4, String var5) throws IOException;

    protected void addPart(DuelPart part) {
        if (part == null || part.getPartName() == null) {
            return;
        }
        if (this.parts == null) {
            this.parts = new HashMap<String, DuelPart>(4);
        }
        this.parts.put(part.getPartName(), part);
    }

    protected void renderPart(DuelContext context, String partName, Object data, int index, int count, String key) throws IOException {
        if (this.parts == null || !this.parts.containsKey(partName)) {
            return;
        }
        DuelPart part = this.parts.get(partName);
        if (part == null) {
            return;
        }
        part.render(context, data, index, count, key);
    }

    protected void renderView(DuelContext context, DuelView view, Object data, int index, int count, String key) throws IOException {
        view.render(context, data, index, count, key);
    }

    protected void write(DuelContext context, Object value) throws IOException {
        if (value == null) {
            return;
        }
        context.getOutput().append(DuelData.coerceString(value));
    }

    protected void write(DuelContext context, char value) throws IOException {
        context.getOutput().append(value);
    }

    protected void write(DuelContext context, String value) throws IOException {
        context.getOutput().append(value);
    }

    protected void htmlEncode(DuelContext context, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Boolean || value instanceof Number) {
            context.getOutput().append(DuelData.coerceString(value));
        } else {
            formatter.writeLiteral(context.getOutput(), DuelData.coerceString(value), context.getFormat().getEncodeNonASCII());
        }
    }

    protected void dataEncode(DuelContext context, Object data, int depth) throws IOException {
        context.getEncoder().write(context.getOutput(), data, depth);
    }

    protected Object getExtra(DuelContext context, String ident) {
        return context.getExtra(ident);
    }

    protected void putExtra(DuelContext context, String ident, Object value) {
        context.putExtra(ident, value);
    }

    protected boolean hasExtras(DuelContext context, String ... idents) {
        return context.hasExtras(idents);
    }

    protected void writeExtras(DuelContext context, boolean needsTags) throws IOException {
        if (!context.hasExtrasPending()) {
            return;
        }
        DataEncoder encoder = context.getEncoder();
        Appendable output = context.getOutput();
        if (needsTags) {
            formatter.writeOpenElementBeginTag(output, "script");
            if (context.getFormat().getScriptTypeAttr()) {
                formatter.writeAttribute(output, "type", "text/javascript");
            }
            formatter.writeCloseElementBeginTag(output);
            encoder.writeln(output, 0);
        }
        encoder.writeVars(output, context.getPendingExtras());
        if (needsTags) {
            encoder.indent(output, 1);
            formatter.writeElementEndTag(output, "script");
            output.append("\n\t");
        }
    }

    protected String nextID(DuelContext context) {
        return context.nextID();
    }

    protected String transformURL(DuelContext context, String url) {
        return context.transformURL(url);
    }

    protected Object getProperty(Object data, Object property) {
        if (data == null || property == null) {
            return JSUtility.UNDEFINED;
        }
        Class<?> dataType = data.getClass();
        String key = DuelData.coerceString(property);
        if (DuelData.isString(dataType)) {
            String str = DuelData.coerceString(data);
            if ("length".equals(key)) {
                return str.length();
            }
            if (DuelData.isNumber(property.getClass())) {
                int index = ((Number)DuelData.coerceNumber(property)).intValue();
                if (index < 0 || index >= str.length()) {
                    return JSUtility.UNDEFINED;
                }
                return Character.valueOf(str.charAt(index));
            }
            return JSUtility.UNDEFINED;
        }
        if (DuelData.isArray(dataType)) {
            Collection<?> array = DuelData.coerceCollection(data);
            if ("length".equals(key)) {
                return array.size();
            }
            if (DuelData.isNumber(property.getClass()) && array instanceof List) {
                int index = ((Number)DuelData.coerceNumber(property)).intValue();
                if (index < 0 || index >= array.size()) {
                    return JSUtility.UNDEFINED;
                }
                return DuelData.asProxy(((List)array).get(index), true);
            }
            return JSUtility.UNDEFINED;
        }
        Map<?, ?> map = DuelData.coerceMap(data);
        if (map == null || !map.containsKey(key)) {
            return JSUtility.UNDEFINED;
        }
        return DuelData.asProxy(map.get(key), true);
    }

    protected void setProperty(Object data, Object property, Object value) {
        if (data == null || property == null) {
            return;
        }
        Class<?> dataType = data.getClass();
        if (Map.class.isAssignableFrom(dataType)) {
            Map map = (Map)data;
            map.put(DuelData.coerceString(property), value);
            return;
        }
        if (dataType.isArray()) {
            if (DuelData.isNumber(property.getClass())) {
                int index = ((Number)DuelData.coerceNumber(property)).intValue();
                if (index < 0 || index >= Array.getLength(data)) {
                    return;
                }
                Array.set(data, index, value);
                return;
            }
            return;
        }
        if (List.class.isAssignableFrom(dataType)) {
            List array = (List)data;
            if (DuelData.isNumber(property.getClass())) {
                int index = ((Number)DuelData.coerceNumber(property)).intValue();
                if (index < 0 || index >= array.size()) {
                    return;
                }
                array.set(index, data);
                return;
            }
            return;
        }
    }

    protected boolean equal(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    protected boolean coerceEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        Class<?> aType = a.getClass();
        if (DuelData.isNumber(aType)) {
            a = DuelData.coerceNumber(a);
            b = DuelData.coerceNumber(b);
        } else if (DuelData.isString(aType)) {
            b = DuelData.coerceString(b);
        } else if (DuelData.isBoolean(aType)) {
            b = DuelData.coerceBoolean(b);
        }
        return a.equals(b);
    }

    protected Object LogicalOR(Object left, Object right) {
        return DuelData.coerceBoolean(left) ? left : right;
    }

    protected Object LogicalAND(Object left, Object right) {
        return DuelData.coerceBoolean(left) ? right : left;
    }

    protected double echo(double value, double ignore) {
        return value;
    }
}

