/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.duelengine.duel.staticapps.SiteBuilder;
import org.duelengine.duel.staticapps.SiteConfig;
import org.duelengine.duel.staticapps.maven.MavenLoggerAdapterFactory;
import org.duelengine.duel.utils.FileUtil;

public class SiteGeneratorMojo
extends AbstractMojo {
    private MavenProject project;
    private PluginDescriptor descriptor;
    private String configPath;

    public void setLog(Log log) {
        super.setLog(log);
        MavenLoggerAdapterFactory.setMavenLogger(log);
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            log.info((CharSequence)"adding build dependencies and target to classPath");
            ClassRealm realm = this.descriptor.getClassRealm();
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            ArrayList<URL> runtimeUrls = new ArrayList<URL>(runtimeClasspathElements.size());
            for (String element : runtimeClasspathElements) {
                try {
                    URL elementURL = FileUtil.getCanonicalFile((String)element).toURI().toURL();
                    runtimeUrls.add(elementURL);
                    if (realm == null) continue;
                    realm.addURL(elementURL);
                }
                catch (MalformedURLException ex) {
                    log.error((Throwable)ex);
                }
            }
            classLoader = new URLClassLoader(runtimeUrls.toArray(new URL[runtimeUrls.size()]), classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (DependencyResolutionRequiredException ex) {
            log.error((Throwable)ex);
        }
        try {
            File configFile = new File(this.configPath);
            if (!configFile.isFile()) {
                throw new FileNotFoundException(configFile.getPath());
            }
            SiteConfig config = (SiteConfig)new ObjectMapper().reader(SiteConfig.class).readValue(configFile);
            config.sourceDir(new File(configFile.getParentFile(), config.sourceDir()).getPath()).targetDir(new File(configFile.getParentFile(), config.targetDir()).getPath());
            new SiteBuilder(classLoader).build(config);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

