/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.FormatPrefs;
import org.duelengine.duel.LinkInterceptor;
import org.duelengine.duel.staticapps.SiteConfig;
import org.duelengine.duel.staticapps.SiteViewPage;
import org.duelengine.duel.staticapps.StaticLinkInterceptor;
import org.duelengine.duel.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteBuilder {
    private static final Logger log = LoggerFactory.getLogger(SiteBuilder.class);
    private static final int BUFFER_SIZE = 65536;
    private final byte[] buffer = new byte[65536];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(SiteConfig config) throws FileNotFoundException {
        String[] staticFiles;
        if (config == null) {
            throw new NullPointerException("config");
        }
        File sourceDir = config.sourceDirFile();
        File targetDir = config.targetDirFile();
        if (sourceDir == null) {
            throw new NullPointerException("sourceDir");
        }
        if (targetDir == null) {
            throw new NullPointerException("targetDir");
        }
        if (!sourceDir.exists()) {
            throw new FileNotFoundException(sourceDir.getPath());
        }
        log.info("webapp source: " + sourceDir);
        log.info("static target: " + targetDir);
        File cdnDir = new File(targetDir, "cdn");
        if (cdnDir.isDirectory() && cdnDir.exists()) {
            log.info("Emptying existing CDN dir: " + cdnDir.getAbsolutePath());
            for (File child : cdnDir.listFiles()) {
                try {
                    if (!child.delete()) continue;
                    log.trace("Deleting existing: " + child.getAbsolutePath());
                }
                catch (Exception ex) {
                    log.warn(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        StaticLinkInterceptor linkInterceptor = null;
        try {
            String bundleName = config.cdnMap();
            ResourceBundle cdnBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT);
            bundleName = config.cdnLinksMap();
            ResourceBundle cdnLinkBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT);
            linkInterceptor = new StaticLinkInterceptor(config.cdnHost(), cdnBundle, cdnLinkBundle, config.isDevMode());
        }
        catch (URISyntaxException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        FormatPrefs formatPrefs = new FormatPrefs().setEncoding("UTF-8").setIndent("").setNewline("");
        Map<String, SiteViewPage> views = config.views();
        if (views != null) {
            for (String targetPage : views.keySet()) {
                SiteViewPage view = views.get(targetPage);
                log.info("source view: " + view.view());
                log.info("target page: " + targetPage);
                OutputStreamWriter writer = null;
                try {
                    File indexFile = new File(targetDir, targetPage);
                    FileUtil.prepSavePath(indexFile);
                    writer = new FileWriter(indexFile);
                    DuelContext context = new DuelContext().setFormat(formatPrefs).setLinkInterceptor((LinkInterceptor)linkInterceptor).setData(view.data()).setOutput((Appendable)writer);
                    Map<String, Object> extras = view.extras();
                    if (extras != null && !extras.isEmpty()) {
                        context.putExtras(extras);
                    }
                    log.trace("Generating: " + targetPage);
                    SiteBuilder.viewClass(config.serverPrefix(), view.view()).newInstance().render(context);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (writer == null) continue;
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        if ((staticFiles = config.files()) != null) {
            for (String staticFile : staticFiles) {
                try {
                    this.copyResource(sourceDir, targetDir, staticFile, staticFile);
                }
                catch (IOException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        Map<String, String> linkCache = linkInterceptor.getLinkCache();
        for (String key : linkCache.keySet()) {
            try {
                this.copyResource(sourceDir, targetDir, key, linkCache.get(key));
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void copyResource(File sourceDir, File targetDir, String path, String cdnPath) throws IOException {
        if (cdnPath.indexOf(63) >= 0) {
            cdnPath = cdnPath.substring(0, cdnPath.indexOf(63));
        }
        if (cdnPath.indexOf(35) >= 0) {
            cdnPath = cdnPath.substring(0, cdnPath.indexOf(35));
        }
        File resource = new File(sourceDir, cdnPath);
        File target = new File(targetDir, cdnPath);
        if (!resource.exists()) {
            log.warn("Resource not found: " + resource.getAbsolutePath());
            try {
                if (target.isFile() && target.exists() && target.delete()) {
                    log.info("Deleted existing: " + target.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        if (!resource.isFile()) {
            log.warn("Resource not a file: " + resource.getPath());
            try {
                if (target.isFile() && target.exists() && target.delete()) {
                    log.info("Deleted existing: " + target.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        log.info("Copying " + path + " as " + cdnPath);
        FileUtil.copy(resource, target, true, this.buffer);
    }

    private static Class<? extends DuelView> viewClass(String serverPrefix, String viewName) throws ClassNotFoundException {
        if (serverPrefix != null && !serverPrefix.isEmpty()) {
            viewName = serverPrefix.endsWith(".") ? serverPrefix + viewName : serverPrefix + '.' + viewName;
        }
        return Class.forName(viewName).asSubclass(DuelView.class);
    }
}

