/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.duelengine.duel.CDNLinkInterceptor;

class StaticLinkInterceptor
extends CDNLinkInterceptor {
    private final Map<String, String> cache = new HashMap<String, String>();
    private final ResourceBundle linksBundle;
    private final boolean isDevMode;
    private final int cdnHostPrefix;

    public StaticLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, ResourceBundle linksBundle, boolean isDevMode) throws URISyntaxException {
        super(cdnHost, cdnBundle, isDevMode);
        this.linksBundle = linksBundle;
        this.isDevMode = isDevMode;
        this.cdnHostPrefix = cdnHost == null ? 0 : cdnHost.length();
    }

    public Map<String, String> getLinkCache() {
        return this.cache;
    }

    public String transformURL(String url) {
        if (this.cache.containsKey(url)) {
            return this.cache.get(url);
        }
        String cdnURL = super.transformURL(url);
        this.cache.put(url, cdnURL);
        if (this.linksBundle != null) {
            String childLinks;
            if (this.linksBundle.containsKey(url) && (childLinks = this.linksBundle.getString(url)) != null && !childLinks.isEmpty()) {
                for (String child : childLinks.split("\\|")) {
                    if (child == null || child.isEmpty()) continue;
                    this.transformURL(child);
                }
            }
            if (this.isDevMode && cdnURL.length() > this.cdnHostPrefix && this.linksBundle.containsKey(cdnURL.substring(this.cdnHostPrefix)) && (childLinks = this.linksBundle.getString(cdnURL.substring(this.cdnHostPrefix))) != null && !childLinks.isEmpty()) {
                for (String child : childLinks.split("\\|")) {
                    if (child == null || child.isEmpty()) continue;
                    this.transformURL(child);
                }
            }
        }
        return cdnURL;
    }
}

