/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int SHA1_HEX_LENGTH = 40;
    private static final int SHA1_BASE64_LENGTH = 27;
    private static final int MD5_HEX_LENGTH = 32;
    private static final int MD5_BASE64_LENGTH = 22;
    public static final String SHA1 = "SHA-1";
    public static final String MD5 = "MD5";

    public static void prepSavePath(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    public static void copy(File source, File target, boolean overwrite) throws IOException {
        FileUtil.copy(source, target, overwrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target, boolean overwrite, byte[] buffer) throws IOException {
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!source.exists()) {
            throw new FileNotFoundException(source.toString());
        }
        if (!source.isFile()) {
            return;
        }
        if (!overwrite && target.exists()) {
            return;
        }
        if (buffer == null) {
            buffer = new byte[4096];
        }
        FileUtil.prepSavePath(target);
        FileInputStream sourceStream = null;
        FileOutputStream targetStream = null;
        try {
            int count;
            sourceStream = new FileInputStream(source);
            targetStream = new FileOutputStream(target);
            while ((count = sourceStream.read(buffer)) > 0) {
                targetStream.write(buffer, 0, count);
            }
        }
        finally {
            if (targetStream != null) {
                try {
                    targetStream.close();
                }
                catch (IOException e) {}
            }
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static List<File> findFiles(File root, String ... extensions) {
        if (extensions == null || extensions.length < 1) {
            return FileUtil.findFiles(root, (Set<String>)null);
        }
        HashSet<String> extSet = new HashSet<String>(extensions.length);
        for (String ext : extensions) {
            extSet.add(ext);
        }
        return FileUtil.findFiles(root, extSet);
    }

    public static List<File> findFiles(File root, Set<String> extensions) {
        boolean noFilter = extensions == null || extensions.size() < 1;
        ArrayList<File> files = new ArrayList<File>();
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(root);
        while (!dirs.isEmpty()) {
            File file = (File)dirs.remove();
            if (file.isDirectory()) {
                dirs.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            String ext = FileUtil.getExtension(file.getName());
            if (noFilter || extensions.contains(ext)) {
                files.add(file);
                continue;
            }
            log.info("Skipping: " + file.getName());
        }
        if (files.size() < 1) {
            log.warn("No input files found.");
        }
        return files;
    }

    public static String getRelativePath(File root, File child) {
        String path;
        String prefix;
        try {
            prefix = root.getCanonicalPath();
        }
        catch (IOException e) {
            prefix = root.getAbsolutePath();
        }
        try {
            path = child.getCanonicalPath();
        }
        catch (IOException e) {
            path = child.getAbsolutePath();
        }
        if (path.indexOf(prefix) != 0) {
            return child.getPath();
        }
        if (prefix.length() == path.length()) {
            return "";
        }
        int start = prefix.length();
        if (path.charAt(start) == '/') {
            ++start;
        }
        return path.substring(start);
    }

    public static String getExtension(File file) {
        if (file == null) {
            return "";
        }
        return FileUtil.getExtension(file.getName());
    }

    public static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return name.substring(dot).toLowerCase();
    }

    public static File replaceExtension(File file, String ext) {
        String newName;
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (ext == null || ext.isEmpty()) {
            throw new NullPointerException("ext");
        }
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        String string = newName = dot < 0 ? name : name.substring(0, dot);
        if (ext.indexOf(46) != 0) {
            ext = '.' + ext;
        }
        newName = newName + ext;
        return new File(file.getParentFile(), newName);
    }

    public static String calcSHA1(File file) throws FileNotFoundException {
        return FileUtil.calcHash(file, SHA1, HashEncoding.DEFAULT, null);
    }

    public static String calcMD5(File file) throws FileNotFoundException {
        return FileUtil.calcHash(file, MD5, HashEncoding.DEFAULT, null);
    }

    public static String calcHash(File file, String algorithm, HashEncoding encoding) throws FileNotFoundException {
        return FileUtil.calcHash(file, algorithm, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calcHash(File file, String algorithm, HashEncoding encoding, byte[] buffer) throws FileNotFoundException {
        String string;
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (buffer == null) {
            buffer = new byte[4096];
        }
        FileInputStream stream = null;
        try {
            int count;
            MessageDigest hash = MessageDigest.getInstance(algorithm);
            stream = new FileInputStream(file);
            while ((count = stream.read(buffer)) > 0) {
                hash.update(buffer, 0, count);
            }
            byte[] digest = hash.digest();
            switch (encoding) {
                case BASE64: {
                    String string2 = FileUtil.encodeBytesBase64(digest);
                    return string2;
                }
            }
            string = FileUtil.encodeBytesHex(digest);
        }
        catch (Exception ex) {
            log.error(algorithm + " Error", (Throwable)ex);
            String string3 = null;
            return string3;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return string;
    }

    public static boolean isSHA1(String signature) {
        if (signature == null) {
            return false;
        }
        switch (signature.length()) {
            case 40: {
                return FileUtil.isHex(signature);
            }
            case 27: {
                return Base64.isBase64((String)signature);
            }
        }
        return false;
    }

    public static boolean isMD5(String signature) {
        if (signature == null) {
            return false;
        }
        switch (signature.length()) {
            case 32: {
                return FileUtil.isHex(signature);
            }
            case 22: {
                return Base64.isBase64((String)signature);
            }
        }
        return false;
    }

    private static boolean isHex(String signature) {
        if (signature == null || signature.isEmpty()) {
            return false;
        }
        for (int i = signature.length() - 1; i >= 0; --i) {
            char ch = signature.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
            return false;
        }
        return true;
    }

    private static String encodeBytesBase64(byte[] digest) {
        return Base64.encodeBase64URLSafeString((byte[])digest);
    }

    private static String encodeBytesHex(byte[] digest) {
        StringBuilder hex = new StringBuilder(40);
        for (int i = 0; i < digest.length; ++i) {
            int digit = 0xFF & digest[i];
            if (digit < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(digit));
        }
        return hex.toString();
    }

    public static enum HashEncoding {
        DEFAULT,
        HEX,
        BASE64;

    }
}

