/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.duelengine.duel.CDNLinkInterceptor;

class StaticLinkInterceptor
extends CDNLinkInterceptor {
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Map<String, String> linksBundle;
    private final int cdnHostPrefix;

    public StaticLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, ResourceBundle linksBundle, boolean isDevMode) throws URISyntaxException {
        this(cdnHost, StaticLinkInterceptor.bundleAsMap((ResourceBundle)cdnBundle, (boolean)isDevMode), StaticLinkInterceptor.bundleAsMap((ResourceBundle)linksBundle, (boolean)isDevMode), isDevMode);
    }

    public StaticLinkInterceptor(String cdnHost, Map<String, String> cdnBundle, Map<String, String> linksBundle, boolean isDevMode) throws URISyntaxException {
        super(cdnHost, cdnBundle, isDevMode);
        this.linksBundle = linksBundle;
        this.cdnHostPrefix = cdnHost == null ? 0 : cdnHost.length();
    }

    public Map<String, String> getLinkCache() {
        return this.cache;
    }

    public String transformURL(String url) {
        String childLinks;
        if (this.cache.containsKey(url)) {
            return this.cache.get(url);
        }
        String cdnURL = super.transformURL(url);
        this.cache.put(url, cdnURL);
        if (this.linksBundle.containsKey(url) && (childLinks = this.linksBundle.get(url)) != null && !childLinks.isEmpty()) {
            for (String child : childLinks.split("\\|")) {
                if (child == null || child.isEmpty()) continue;
                this.transformURL(child);
            }
        }
        if (this.isDevMode && cdnURL.length() > this.cdnHostPrefix && this.linksBundle.containsKey(cdnURL.substring(this.cdnHostPrefix)) && (childLinks = this.linksBundle.get(cdnURL.substring(this.cdnHostPrefix))) != null && !childLinks.isEmpty()) {
            for (String child : childLinks.split("\\|")) {
                if (child == null || child.isEmpty()) continue;
                this.transformURL(child);
            }
        }
        return cdnURL;
    }
}

