/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.duelengine.duel.CDNLinkInterceptor;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.FormatPrefs;
import org.duelengine.duel.LinkInterceptor;
import org.duelengine.duel.staticapps.SiteConfig;
import org.duelengine.duel.staticapps.SiteViewPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RoutingServlet.class);
    private static final long serialVersionUID = 8465487004837241467L;
    private static final String DEFAULT_DOC = "index.html";
    private SiteConfig config;
    private FormatPrefs format;
    private LinkInterceptor linkInterceptor;

    public void init(ServletConfig servletConfig) throws ServletException {
        String devModeOverride;
        super.init(servletConfig);
        String configPath = null;
        try {
            configPath = servletConfig.getInitParameter("config-path");
            if (configPath == null || configPath.isEmpty()) {
                this.config = null;
            } else {
                File configFile = new File(configPath);
                if (configFile.exists()) {
                    log.info("Loading config from file path: " + configFile.getPath());
                    this.config = (SiteConfig)new ObjectMapper().reader(SiteConfig.class).readValue(configFile);
                }
            }
        }
        catch (Exception ex) {
            log.error("Error loading staticapp config from 'config-path' param in WEB-INF/web.xml: " + configPath, (Throwable)ex);
            this.config = null;
        }
        if (this.config == null) {
            try {
                configPath = servletConfig.getInitParameter("config-resource");
                log.info("Loading config from resource: " + configPath);
                InputStream stream = this.getServletContext().getResourceAsStream(configPath);
                this.config = (SiteConfig)new ObjectMapper().reader(SiteConfig.class).readValue(stream);
            }
            catch (Exception ex) {
                log.error("Error loading staticapp config from 'config-resource' param in WEB-INF/web.xml: " + configPath, (Throwable)ex);
                this.config = new SiteConfig();
            }
        }
        if ((devModeOverride = servletConfig.getInitParameter("dev-mode-override")) != null && !devModeOverride.isEmpty()) {
            log.info("dev-mode-override=" + devModeOverride);
            this.config.isDevMode(Boolean.parseBoolean(devModeOverride));
        }
        this.format = new FormatPrefs().setEncoding(this.config.encoding()).setIndent(this.config.isDevMode() ? "\t" : "").setNewline(this.config.isDevMode() ? "\n" : "");
        try {
            String bundleName = this.config.cdnMap();
            ResourceBundle cdnBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT);
            this.linkInterceptor = new CDNLinkInterceptor(this.config.cdnHost(), cdnBundle, this.config.isDevMode());
        }
        catch (URISyntaxException ex) {
            log.error("CDN URI Error", (Throwable)ex);
            this.linkInterceptor = new LinkInterceptor(){

                public String transformURL(String url) {
                    return url + "#CDN-ERROR";
                }
            };
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            DuelView view;
            response.setContentType(this.config.contentType());
            response.setCharacterEncoding(this.config.encoding());
            SiteViewPage sitePage = this.route(request.getServletPath());
            if (sitePage == null) {
                this.defaultServlet(request, response);
                return;
            }
            DuelContext context = new DuelContext().setFormat(this.format).setLinkInterceptor(this.linkInterceptor).setData(sitePage.data()).setOutput((Appendable)response.getWriter());
            if (sitePage.extras() != null) {
                context.putExtras(sitePage.extras());
            }
            if ((view = sitePage.viewInstance(this.config.serverPrefix(), Thread.currentThread().getContextClassLoader())) == null) {
                this.defaultServlet(request, response);
                return;
            }
            view.render(context);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace(response.getWriter());
                response.sendError(500);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private SiteViewPage route(String servletPath) {
        log.info("routing: " + servletPath);
        if (this.config.views() == null) {
            return null;
        }
        SiteViewPage page = this.config.views().get(servletPath.substring(1));
        if (page == null && servletPath.endsWith("/")) {
            log.info("routing: " + servletPath + DEFAULT_DOC);
            page = this.config.views().get(servletPath.substring(1) + DEFAULT_DOC);
        }
        return page;
    }

    private void defaultServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
    }
}

