/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.duelengine.duel.CDNLinkInterceptor;

class StaticLinkInterceptor
extends CDNLinkInterceptor {
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Map<String, String> linksBundle;
    private final int cdnHostPrefix;

    public StaticLinkInterceptor(String cdnHost, ResourceBundle cdnBundle, ResourceBundle linksBundle, boolean isDevMode) throws URISyntaxException {
        this(cdnHost, StaticLinkInterceptor.bundleAsMap((ResourceBundle)cdnBundle, (boolean)isDevMode), StaticLinkInterceptor.bundleAsMap((ResourceBundle)linksBundle, (boolean)isDevMode), isDevMode);
    }

    public StaticLinkInterceptor(String cdnHost, Map<String, String> cdnBundle, Map<String, String> linksBundle, boolean isDevMode) throws URISyntaxException {
        super(cdnHost, cdnBundle, isDevMode);
        this.linksBundle = linksBundle;
        this.cdnHostPrefix = cdnHost == null ? 0 : cdnHost.length();
    }

    public Map<String, String> getLinkCache() {
        return this.cache;
    }

    public String transformURL(String url) {
        String childLinks;
        int hash;
        if (url.indexOf("://") > 0 || url.indexOf("//") == 0) {
            return url;
        }
        String suffix = "";
        int query = url.indexOf(63);
        if (query >= 0) {
            suffix = suffix + url.substring(query);
            url = url.substring(0, query);
        }
        if ((hash = url.indexOf(35)) >= 0) {
            suffix = suffix + url.substring(hash);
            url = url.substring(0, hash);
        }
        if (this.cache.containsKey(url)) {
            return this.cache.get(url);
        }
        String cdnURL = super.transformURL(url);
        this.cache.put(url, cdnURL + suffix);
        if (this.linksBundle.containsKey(url) && (childLinks = this.linksBundle.get(url)) != null && !childLinks.isEmpty()) {
            for (String child : childLinks.split("\\|")) {
                if (child == null || child.isEmpty()) continue;
                this.transformURL(child);
            }
        }
        if (this.isDevMode && cdnURL.length() > this.cdnHostPrefix && this.linksBundle.containsKey(cdnURL.substring(this.cdnHostPrefix)) && (childLinks = this.linksBundle.get(cdnURL.substring(this.cdnHostPrefix))) != null && !childLinks.isEmpty()) {
            for (String child : childLinks.split("\\|")) {
                if (child == null || child.isEmpty()) continue;
                this.transformURL(child);
            }
        }
        return cdnURL + suffix;
    }
}

