/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duelengine.duel.CDNLinkInterceptor;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.FormatPrefs;
import org.duelengine.duel.LinkInterceptor;
import org.duelengine.duel.staticapps.SiteConfig;
import org.duelengine.duel.staticapps.SiteViewPage;
import org.duelengine.duel.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RoutingServlet.class);
    private static final long serialVersionUID = 8465487004837241467L;
    private static final String DEFAULT_DOC = "index.html";
    private SiteConfig config;
    private FormatPrefs format;
    private LinkInterceptor linkInterceptor;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String configPath = null;
        try {
            configPath = System.getProperty("org.duelengine.duel.staticapps.configPath");
            if (configPath == null || configPath.isEmpty()) {
                log.info("Loading config-path from WEB-INF/web.xml");
                configPath = servletConfig.getInitParameter("config-path");
            }
            if (configPath == null || configPath.isEmpty()) {
                this.config = null;
            } else {
                File configFile = new File(configPath);
                if (configFile.exists()) {
                    log.info("Loading config from file path: " + configFile.getPath());
                    this.config = (SiteConfig)new ObjectMapper().reader(SiteConfig.class).readValue(configFile);
                } else {
                    log.error("File not found from 'config-path' param: " + configPath);
                    configPath = null;
                }
            }
        }
        catch (Throwable ex) {
            log.error("Error loading staticapp config from 'config-path' param: " + configPath, ex);
            this.config = null;
        }
        if (this.config == null) {
            try {
                configPath = System.getProperty("org.duelengine.duel.staticapps.configResource");
                if (configPath == null || configPath.isEmpty()) {
                    log.info("Loading config-resource from WEB-INF/web.xml");
                    configPath = servletConfig.getInitParameter("config-resource");
                }
                log.info("Loading config from resource: " + configPath);
                InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(configPath);
                this.config = (SiteConfig)new ObjectMapper().reader(SiteConfig.class).readValue(stream);
            }
            catch (Throwable ex) {
                log.error("Error loading staticapp config from 'config-resource' param: " + configPath, ex);
                this.config = null;
            }
        }
        if (this.config == null) {
            this.config = new SiteConfig();
        }
        this.format = new FormatPrefs().setEncoding(this.config.encoding()).setIndent(this.config.isDevMode() ? "\t" : "").setNewline(this.config.isDevMode() ? "\n" : "");
        try {
            String bundleName = this.config.cdnMap();
            ResourceBundle cdnBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT);
            this.linkInterceptor = new CDNLinkInterceptor(this.config.cdnHost(), cdnBundle, this.config.isDevMode());
        }
        catch (URISyntaxException ex) {
            log.error("CDN URI Error", (Throwable)ex);
            this.linkInterceptor = new LinkInterceptor(){

                public String transformURL(String url) {
                    return url + "#CDN-ERROR";
                }
            };
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            DuelView view;
            String servletPath = request.getServletPath();
            SiteViewPage sitePage = this.route(servletPath);
            if (sitePage == null) {
                log.debug("routing: " + servletPath + " (static)");
                this.defaultServlet(request, response);
                return;
            }
            DuelContext context = new DuelContext().setFormat(this.format).setLinkInterceptor(this.linkInterceptor).setData(sitePage.data()).setOutput((Appendable)response.getWriter());
            if (sitePage.extras() != null) {
                context.putExtras(sitePage.extras());
            }
            if ((view = sitePage.viewInstance(this.config.serverPrefix(), Thread.currentThread().getContextClassLoader())) == null) {
                log.error("routing: " + servletPath + " view instance missing");
                this.defaultServlet(request, response);
                return;
            }
            response.setContentType(this.config.contentType());
            response.setCharacterEncoding(this.config.encoding());
            view.render(context);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace(response.getWriter());
                response.sendError(500);
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private SiteViewPage route(String servletPath) {
        if (this.config.views() == null) {
            return null;
        }
        SiteViewPage page = this.config.views().get(servletPath.substring(1));
        if (page != null) {
            log.info("routing: " + servletPath);
        } else {
            String aliasedPath = servletPath;
            if ("".equals(FileUtil.getExtension(aliasedPath))) {
                if (!aliasedPath.endsWith("/")) {
                    aliasedPath = aliasedPath + '/';
                }
                aliasedPath = aliasedPath + DEFAULT_DOC;
                page = this.config.views().get(aliasedPath.substring(1));
            }
            if (page != null) {
                log.info("routing: " + servletPath + " [as " + aliasedPath + "]");
            } else {
                String ext = FileUtil.getExtension(aliasedPath);
                page = this.config.views().get("*" + ext);
                if (page != null) {
                    log.info("routing: " + servletPath + " [as *" + ext + "]");
                }
            }
        }
        return page;
    }

    private void defaultServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)request, (ServletResponse)response);
    }
}

