/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.staticapps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.FormatPrefs;
import org.duelengine.duel.LinkInterceptor;
import org.duelengine.duel.staticapps.CacheManifest;
import org.duelengine.duel.staticapps.CacheManifestWriter;
import org.duelengine.duel.staticapps.SiteConfig;
import org.duelengine.duel.staticapps.SiteViewPage;
import org.duelengine.duel.staticapps.StaticLinkInterceptor;
import org.duelengine.duel.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteBuilder {
    private static final Logger log = LoggerFactory.getLogger(SiteBuilder.class);
    private static final Appendable NOOP_OUTPUT = new Appendable(){

        @Override
        public Appendable append(CharSequence value, int start, int end) throws IOException {
            return this;
        }

        @Override
        public Appendable append(char value) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence value) throws IOException {
            return this;
        }
    };
    private static final int BUFFER_SIZE = 0x100000;
    private final byte[] buffer = new byte[0x100000];
    private final ClassLoader classLoader;

    public SiteBuilder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public SiteBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(SiteConfig config) throws FileNotFoundException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        File sourceDir = config.sourceDirFile();
        File targetDir = config.targetDirFile();
        if (sourceDir == null) {
            throw new NullPointerException("sourceDir");
        }
        if (targetDir == null) {
            throw new NullPointerException("targetDir");
        }
        if (!sourceDir.exists()) {
            throw new FileNotFoundException(sourceDir.getPath());
        }
        log.info("webapp source: " + sourceDir);
        log.info("static target: " + targetDir);
        File cdnDir = new File(targetDir, "cdn");
        if (cdnDir.isDirectory() && cdnDir.exists()) {
            log.info("Emptying existing CDN dir: " + cdnDir.getAbsolutePath());
            for (File child : cdnDir.listFiles()) {
                try {
                    if (!child.delete()) continue;
                    log.trace("Deleting existing: " + child.getAbsolutePath());
                }
                catch (Exception ex) {
                    log.warn(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        StaticLinkInterceptor linkInterceptor = this.createInterceptor(config);
        FormatPrefs formatPrefs = new FormatPrefs().setEncoding(config.encoding()).setIndent(config.isDevMode() ? "\t" : "").setNewline(config.isDevMode() ? "\n" : "");
        Map<String, String> linkCache = null;
        Map<String, SiteViewPage> views = config.views();
        if (views != null) {
            for (String targetPage : views.keySet()) {
                SiteViewPage sitePage = views.get(targetPage);
                log.info("Generating: " + sitePage.view() + " => " + targetPage);
                if (sitePage.appCache() != null) {
                    if (linkCache == null) {
                        linkCache = new HashMap<String, String>();
                    }
                    linkCache.putAll(linkInterceptor.getLinkCache());
                    linkInterceptor.getLinkCache().clear();
                }
                OutputStreamWriter writer = null;
                try {
                    CacheManifest cacheManifest;
                    DuelView view;
                    File targetFile = new File(targetDir, targetPage);
                    FileUtil.prepSavePath(targetFile);
                    writer = new FileWriter(targetFile);
                    DuelContext context = new DuelContext().setFormat(formatPrefs).setLinkInterceptor((LinkInterceptor)linkInterceptor).setData(sitePage.data()).setOutput((Appendable)writer);
                    Map<String, Object> extras = config.extras();
                    if (extras != null) {
                        context.putExtras(extras);
                    }
                    if ((extras = sitePage.extras()) != null) {
                        context.putExtras(extras);
                    }
                    if ((view = sitePage.viewInstance(config.serverPrefix(), this.classLoader)) != null) {
                        view.render(context);
                    }
                    if ((cacheManifest = sitePage.appCache()) == null) continue;
                    cacheManifest.addCachePaths(linkInterceptor.getLinkCache().values());
                    new CacheManifestWriter().write(targetDir, cacheManifest);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (writer == null) continue;
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        if (linkCache != null && !linkCache.isEmpty()) {
            linkInterceptor.getLinkCache().putAll(linkCache);
        }
        linkCache = linkInterceptor.getLinkCache();
        String[] staticFiles = config.files();
        if (staticFiles != null) {
            for (String staticFile : staticFiles) {
                try {
                    this.copyResource(sourceDir, targetDir, staticFile, staticFile);
                }
                catch (IOException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        for (String key : linkCache.keySet()) {
            try {
                this.copyResource(sourceDir, targetDir, key, linkCache.get(key));
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void generateManifests(SiteConfig config) throws FileNotFoundException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        StaticLinkInterceptor linkInterceptor = null;
        for (SiteViewPage sitePage : config.views().values()) {
            if (sitePage.appCache() == null) continue;
            if (linkInterceptor == null) {
                linkInterceptor = this.createInterceptor(config);
            } else if (!linkInterceptor.getLinkCache().isEmpty()) {
                linkInterceptor.getLinkCache().clear();
            }
            try {
                DuelView view;
                DuelContext context = new DuelContext().setLinkInterceptor((LinkInterceptor)linkInterceptor).setData(sitePage.data()).setOutput(NOOP_OUTPUT);
                Map<String, Object> extras = config.extras();
                if (extras != null) {
                    context.putExtras(extras);
                }
                if ((extras = sitePage.extras()) != null) {
                    context.putExtras(extras);
                }
                if ((view = sitePage.viewInstance(config.serverPrefix(), this.classLoader)) != null) {
                    view.render(context);
                }
                sitePage.appCache().addCachePaths(linkInterceptor.getLinkCache().values());
                new CacheManifestWriter().write(config.targetDirFile(), sitePage.appCache());
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private StaticLinkInterceptor createInterceptor(SiteConfig config) {
        StaticLinkInterceptor linkInterceptor = null;
        try {
            String bundleName = config.cdnMap();
            ResourceBundle cdnBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT, this.classLoader);
            bundleName = config.cdnLinksMap();
            ResourceBundle cdnLinkBundle = bundleName == null || bundleName.isEmpty() ? null : ResourceBundle.getBundle(bundleName, Locale.ROOT, this.classLoader);
            linkInterceptor = new StaticLinkInterceptor(config.cdnHost(), cdnBundle, cdnLinkBundle, config.isDevMode());
        }
        catch (URISyntaxException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return linkInterceptor;
    }

    private void copyResource(File sourceDir, File targetDir, String path, String cdnPath) throws IOException {
        if (cdnPath.indexOf(63) >= 0) {
            cdnPath = cdnPath.substring(0, cdnPath.indexOf(63));
        }
        if (cdnPath.indexOf(35) >= 0) {
            cdnPath = cdnPath.substring(0, cdnPath.indexOf(35));
        }
        File source = new File(sourceDir, cdnPath);
        File target = new File(targetDir, cdnPath);
        if (!source.exists()) {
            log.warn("Resource not found: " + source.getAbsolutePath());
            try {
                if (target.isFile() && target.exists() && target.delete()) {
                    log.info("Deleted existing: " + target.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        if (!source.isFile()) {
            log.warn("Resource not a file: " + source.getPath());
            try {
                if (target.isFile() && target.exists() && target.delete()) {
                    log.info("Deleted existing: " + target.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        log.info("Copying " + path + " as " + cdnPath);
        FileUtil.copy(source, target, true, this.buffer);
    }
}

