/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.cssless.css.ast.ContainerNode;
import org.cssless.css.ast.CssNode;
import org.cssless.css.ast.CssNodeType;
import org.cssless.css.ast.FunctionNode;
import org.cssless.css.ast.StringNode;
import org.cssless.css.ast.ValueNode;
import org.cssless.css.codegen.CssFilter;
import org.cssless.css.codegen.CssFormatter;
import org.cssless.css.parsing.CssLexer;

public class LinkInterceptorCssFilter
implements CssFilter {
    private final Logger log = Logger.getLogger(LinkInterceptorCssFilter.class.getCanonicalName());
    private final Map<String, String> linkMap;

    public LinkInterceptorCssFilter(Map<String, String> linkMap) {
        this.linkMap = linkMap;
    }

    public CssNode filter(CssNode node) {
        if (node.getNodeType() != CssNodeType.FUNCTION) {
            return node;
        }
        FunctionNode func = (FunctionNode)node;
        if (!"url".equals(func.getValue())) {
            return node;
        }
        ContainerNode children = func.getContainer();
        if (children.childCount() > 1) {
            StringBuilder buffer = new StringBuilder();
            try {
                new CssFormatter().writeNode((Appendable)buffer, (CssNode)children, null);
            }
            catch (IOException e) {
                return node;
            }
            String value = buffer.toString();
            if (value == null || value.isEmpty()) {
                return node;
            }
            children.getChildren().clear();
            children.getChildren().add(new ValueNode(value));
        }
        for (CssNode child : children.getChildren()) {
            if (child instanceof ValueNode) {
                ValueNode valNode = (ValueNode)child;
                String val = valNode.getValue();
                if ((val = CssLexer.decodeString((String)val)) == null || val.isEmpty()) break;
                String valHash = this.linkMap.get(val);
                if (valHash == null) {
                    this.log.warning("Missing CSS reference: " + val);
                    break;
                }
                valHash = valHash.substring(valHash.lastIndexOf(47) + 1);
                if (child instanceof StringNode) {
                    valHash = CssLexer.encodeString((String)valHash);
                }
                valNode.setValue(valHash);
                this.log.info("CSS url: " + val + " => " + valHash);
                continue;
            }
            this.log.warning("Unexpected CSS url type: " + child.getNodeType());
        }
        return node;
    }
}

