/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import org.cssless.css.ast.ContainerNode;
import org.cssless.css.ast.CssNode;
import org.cssless.css.ast.CssNodeType;
import org.cssless.css.ast.FunctionNode;
import org.cssless.css.ast.StringNode;
import org.cssless.css.ast.ValueNode;
import org.cssless.css.codegen.CssFilter;
import org.cssless.css.codegen.CssFormatter;
import org.cssless.css.parsing.CssLexer;

public class LinkInterceptorCssFilter
implements CssFilter {
    private final Logger log = Logger.getLogger(LinkInterceptorCssFilter.class.getCanonicalName());
    private final Map<String, String> linkMap;
    private final URI context;

    public LinkInterceptorCssFilter(Map<String, String> linkMap, URI context) {
        this.linkMap = linkMap;
        this.context = context;
    }

    public CssNode filter(CssNode node) {
        if (node.getNodeType() != CssNodeType.FUNCTION) {
            return node;
        }
        FunctionNode func = (FunctionNode)node;
        if (!"url".equals(func.getValue())) {
            return node;
        }
        ContainerNode children = func.getContainer();
        if (children.childCount() > 1) {
            StringBuilder buffer = new StringBuilder();
            try {
                new CssFormatter().writeNode((Appendable)buffer, (CssNode)children, null);
            }
            catch (IOException e) {
                return node;
            }
            String value = buffer.toString();
            if (value == null || value.isEmpty()) {
                return node;
            }
            children.getChildren().clear();
            children.getChildren().add(new ValueNode(value));
        }
        for (CssNode child : children.getChildren()) {
            if (child instanceof ValueNode) {
                String valHash;
                URI uri;
                ValueNode valNode = (ValueNode)child;
                String val = valNode.getValue();
                if ((val = CssLexer.decodeString((String)val)) == null || val.isEmpty() || val.startsWith("data:")) break;
                String suffix = "";
                if (val.charAt(0) != '/' && this.context != null && (uri = this.context.resolve(val)).getHost() == null && uri.getScheme() == null) {
                    val = uri.getPath();
                    if (uri.getQuery() != null) {
                        suffix = suffix + '?' + uri.getQuery();
                    }
                    if (uri.getFragment() != null) {
                        suffix = suffix + '#' + uri.getFragment();
                    }
                }
                if ((valHash = this.linkMap.get(val)) == null) {
                    this.log.warning("Missing CSS reference: " + val);
                    break;
                }
                valHash = valHash.substring(valHash.lastIndexOf(47) + 1);
                val = val + suffix;
                valHash = valHash + suffix;
                if (child instanceof StringNode) {
                    valHash = CssLexer.encodeString((String)valHash);
                }
                valNode.setValue(valHash);
                this.log.info("CSS url: " + val + " => " + valHash);
                continue;
            }
            this.log.warning("Unexpected CSS url type: " + child.getNodeType());
        }
        return node;
    }
}

