/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.duelengine.merge.CSSCompactor;
import org.duelengine.merge.CSSPlaceholderGenerator;
import org.duelengine.merge.Compactor;
import org.duelengine.merge.JSCompactor;
import org.duelengine.merge.JSPlaceholderGenerator;
import org.duelengine.merge.NullCompactor;
import org.duelengine.merge.PlaceholderGenerator;

public class MergeBuilder {
    private static final int BUFFER_SIZE = 4096;
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final String CHAR_ENCODING = "utf-8";
    private final Logger log = Logger.getLogger(MergeBuilder.class.getCanonicalName());
    private final Map<String, Compactor> compactors;
    private final Map<String, PlaceholderGenerator> placeholders;
    private File webappDir;
    private File outputDir;
    private File cdnMapFile;
    private String cdnRoot;

    public MergeBuilder(String ... cdnExtensions) {
        this(Arrays.asList(new JSPlaceholderGenerator(), new CSSPlaceholderGenerator()), Arrays.asList(new NullCompactor(cdnExtensions), new CSSCompactor(), new JSCompactor()));
    }

    public MergeBuilder(List<PlaceholderGenerator> placeholders, List<Compactor> compactors) {
        if (placeholders == null) {
            throw new NullPointerException("placeholders");
        }
        if (compactors == null) {
            throw new NullPointerException("compactors");
        }
        this.placeholders = new LinkedHashMap<String, PlaceholderGenerator>(placeholders.size());
        if (placeholders != null) {
            for (PlaceholderGenerator placeholder : placeholders) {
                this.placeholders.put(placeholder.getTargetExtension(), placeholder);
            }
        }
        this.compactors = new LinkedHashMap<String, Compactor>(compactors.size());
        for (Compactor compactor : compactors) {
            for (String ext : compactor.getSourceExtensions()) {
                this.compactors.put(ext, compactor);
            }
        }
    }

    public String getWebAppDir() {
        try {
            return this.webappDir != null ? this.webappDir.getCanonicalPath() : null;
        }
        catch (IOException e) {
            return this.webappDir != null ? this.webappDir.getAbsolutePath() : null;
        }
    }

    public void setWebAppDir(String value) {
        this.webappDir = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getOutputDir() {
        try {
            return this.outputDir != null ? this.outputDir.getCanonicalPath() : null;
        }
        catch (IOException e) {
            return this.outputDir != null ? this.outputDir.getAbsolutePath() : null;
        }
    }

    public void setOutputDir(String value) {
        this.outputDir = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getCDNMapFile() {
        try {
            return this.cdnMapFile != null ? this.cdnMapFile.getCanonicalPath() : null;
        }
        catch (IOException e) {
            return this.cdnMapFile != null ? this.cdnMapFile.getAbsolutePath() : null;
        }
    }

    public void setCDNMapFile(String value) {
        this.cdnMapFile = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getCDNRoot() {
        return this.cdnRoot;
    }

    public void setCDNRoot(String value) {
        if (value != null) {
            if (!(value = value.replace('\\', '/')).startsWith("/")) {
                value = '/' + value;
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
        }
        this.cdnRoot = value;
    }

    private File getCDNDir() {
        return new File(this.getOutputDir(), this.cdnRoot);
    }

    private void ensureSettings() {
        if (this.webappDir == null || !this.webappDir.exists()) {
            throw new IllegalArgumentException("ERROR: missing webappDir " + this.webappDir);
        }
        if (this.cdnMapFile == null) {
            throw new IllegalArgumentException("ERROR: missing cdnMapFile");
        }
        if (this.cdnRoot == null) {
            this.cdnRoot = "/cdn/";
        }
        if (this.outputDir == null) {
            this.outputDir = this.webappDir;
        }
    }

    public void execute() throws IOException, NoSuchAlgorithmException {
        this.ensureSettings();
        LinkedHashMap<String, String> hashLookup = new LinkedHashMap<String, String>();
        for (String ext : this.compactors.keySet()) {
            this.hashClientFiles(hashLookup, ext);
        }
        if (hashLookup.size() < 1) {
            throw new IllegalArgumentException("ERROR: no input files found in " + this.webappDir);
        }
        Map<String, List<String>> dependencyMap = this.hashMergeFiles(hashLookup);
        for (String path : dependencyMap.keySet()) {
            List<String> children = dependencyMap.get(path);
            this.buildMerge(hashLookup, path, children);
            this.buildDebugPlaceholders(hashLookup, path, children);
        }
        this.saveHashLookup(hashLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMerge(Map<String, String> hashLookup, String path, List<String> children) throws FileNotFoundException, IOException {
        this.log.info("Building " + path);
        String outputPath = hashLookup.get(path);
        File outputFile = new File(this.outputDir, outputPath);
        if (outputFile.exists()) {
            this.log.info("- exists: " + outputPath);
            return;
        }
        this.log.info("- writing to " + outputPath);
        outputFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(outputFile, false);
        try {
            char[] buffer = new char[4096];
            for (String child : children) {
                this.log.info("- adding " + child);
                File inputFile = new File(this.outputDir, hashLookup.get(child));
                FileReader reader = new FileReader(inputFile);
                try {
                    int count;
                    while ((count = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, count);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void buildDebugPlaceholders(Map<String, String> hashLookup, String path, List<String> children) throws FileNotFoundException, IOException {
        String hashPath = hashLookup.get(path);
        if (children.size() == 1) {
            hashLookup.put(hashPath, children.get(0));
            return;
        }
        int slash = hashPath.lastIndexOf(47);
        String debugPath = hashPath.substring(0, slash) + "/debug" + hashPath.substring(slash);
        hashLookup.put(hashPath, debugPath);
        File outputFile = new File(this.outputDir, debugPath);
        if (outputFile.exists()) {
            return;
        }
        PlaceholderGenerator generator = this.placeholders.get(MergeBuilder.getExtension(hashPath));
        if (generator == null) {
            this.log.warning("Cannot generate debug placeholder for " + debugPath);
            return;
        }
        generator.build(outputFile, children);
    }

    private Map<String, List<String>> hashMergeFiles(Map<String, String> hashLookup) throws IOException, NoSuchAlgorithmException {
        Map<File, String> inputFiles = MergeBuilder.findFiles(".merge", this.getCDNDir(), this.webappDir, this.outputDir);
        LinkedHashMap<String, List<String>> dependencyMap = new LinkedHashMap<String, List<String>>(inputFiles.size());
        for (File inputFile : inputFiles.keySet()) {
            String child;
            ArrayList<String> children = new ArrayList<String>();
            String path = inputFiles.get(inputFile);
            if (hashLookup.containsKey(path)) continue;
            String hashPath = this.cdnRoot + this.calcMergeHash(inputFile, children, hashLookup);
            String ext = null;
            Iterator i$ = children.iterator();
            while (i$.hasNext() && (ext = MergeBuilder.getExtension(child = (String)i$.next())) == null) {
            }
            if (ext == null) {
                ext = ".merge";
            }
            hashPath = hashPath + ext;
            hashLookup.put(path, hashPath);
            dependencyMap.put(path, children);
        }
        return dependencyMap;
    }

    private void hashClientFiles(Map<String, String> hashLookup, String ext) throws IOException, NoSuchAlgorithmException {
        Compactor compactor = this.compactors.get(ext);
        if (compactor == null) {
            throw new IllegalArgumentException("Error: no compactor registered for " + ext);
        }
        String targetExt = compactor.getTargetExtension();
        if (targetExt == null || targetExt.indexOf(46) < 0) {
            targetExt = ext;
        }
        Map<File, String> inputFiles = MergeBuilder.findFiles(ext, this.getCDNDir(), this.webappDir, this.outputDir);
        for (File inputFile : inputFiles.keySet()) {
            String path = inputFiles.get(inputFile);
            if (hashLookup.containsKey(path)) continue;
            String hashPath = this.cdnRoot + this.calcFileHash(inputFile) + targetExt;
            hashLookup.put(path, hashPath);
            File outputFile = new File(this.outputDir, hashPath);
            if (!outputFile.exists()) {
                compactor.compact(hashLookup, inputFile, outputFile, path);
            }
            if (!outputFile.exists()) {
                this.log.severe(path + " failed to compact (output missing)");
                hashLookup.remove(path);
                continue;
            }
            if (outputFile.length() >= 1L) continue;
            if (inputFile.length() < 1L) {
                this.log.warning(path + " is an empty file");
                hashLookup.remove(path);
                continue;
            }
            this.log.warning(path + " compacted to an empty file (using original)");
            new NullCompactor(new String[0]).compact(hashLookup, inputFile, outputFile, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHashLookup(Map<String, String> hashLookup) throws IOException {
        this.cdnMapFile.getParentFile().mkdirs();
        String newline = System.getProperty("line.separator");
        FileWriter writer = new FileWriter(this.cdnMapFile, false);
        try {
            for (String key : hashLookup.keySet()) {
                writer.append(key).append('=').append(hashLookup.get(key)).append(newline);
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calcMergeHash(File inputFile, List<String> children, Map<String, String> hashLookup) throws NoSuchAlgorithmException, FileNotFoundException, IOException, UnsupportedEncodingException {
        FileReader reader = new FileReader(inputFile);
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            MessageDigest sha1 = MessageDigest.getInstance(HASH_ALGORITHM);
            while ((line = lineReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String childPath = hashLookup.get(line);
                if (childPath == null) {
                    this.log.warning("Missing merge reference: " + line);
                    continue;
                }
                children.add(line);
                sha1.update(childPath.getBytes(CHAR_ENCODING));
            }
            String string = MergeBuilder.encodeBytes(sha1.digest());
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calcFileHash(File inputFile) throws IOException, NoSuchAlgorithmException {
        FileInputStream stream = new FileInputStream(inputFile);
        try {
            int count;
            MessageDigest sha1 = MessageDigest.getInstance(HASH_ALGORITHM);
            byte[] buffer = new byte[4096];
            while ((count = stream.read(buffer)) > 0) {
                sha1.update(buffer, 0, count);
            }
            String string = MergeBuilder.encodeBytes(sha1.digest());
            return string;
        }
        finally {
            stream.close();
        }
    }

    private static String encodeBytes(byte[] digest) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            int digit = 0xFF & digest[i];
            if (digit < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(digit));
        }
        return hex.toString();
    }

    private static String getExtension(String path) {
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return path.substring(dot);
    }

    private static Map<File, String> findFiles(String ext, File filterDir, File ... inputDirs) throws IOException {
        String filterPath = filterDir.getCanonicalPath();
        LinkedHashMap<File, String> files = new LinkedHashMap<File, String>();
        LinkedList<File> folders = new LinkedList<File>();
        for (File inputDir : inputDirs) {
            int rootPrefix = inputDir.getCanonicalPath().length();
            folders.add(inputDir);
            while (!folders.isEmpty()) {
                File file = (File)folders.poll();
                if (file.getCanonicalPath().startsWith(filterPath)) continue;
                if (file.isDirectory()) {
                    folders.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(ext)) continue;
                files.put(file, file.getCanonicalPath().substring(rootPrefix));
            }
        }
        return files;
    }
}

