/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.duelengine.merge.Compactor;

class NullCompactor
implements Compactor {
    private static final int BUFFER_SIZE = 4096;
    private final String[] extensions;

    public NullCompactor(String ... extensions) {
        this.extensions = extensions != null ? extensions : new String[]{};
    }

    @Override
    public String[] getSourceExtensions() {
        return this.extensions;
    }

    @Override
    public String getTargetExtension() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(Map<String, String> fileHashes, File source, File target, String path) throws IOException {
        target.getParentFile().mkdirs();
        FileInputStream inStream = new FileInputStream(source);
        FileOutputStream outStream = new FileOutputStream(target);
        try {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, count);
            }
        }
        finally {
            outStream.flush();
            outStream.close();
            inStream.close();
        }
    }
}

