/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.Compactor;
import org.duelengine.merge.PlaceholderGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeCompactor
implements Compactor {
    private static final int BUFFER_SIZE = 4096;
    private static final String CHAR_ENCODING = "utf-8";
    private final Logger log = LoggerFactory.getLogger(MergeCompactor.class);
    private final Map<String, PlaceholderGenerator> placeholders;

    public MergeCompactor(PlaceholderGenerator ... placeholders) {
        if (placeholders == null) {
            throw new NullPointerException("placeholders");
        }
        this.placeholders = new LinkedHashMap<String, PlaceholderGenerator>(placeholders.length);
        for (PlaceholderGenerator placeholder : placeholders) {
            this.placeholders.put(placeholder.getTargetExtension(), placeholder);
        }
    }

    @Override
    public String[] getSourceExtensions() {
        return new String[]{".merge"};
    }

    @Override
    public String getTargetExtension(BuildManager manager, String path) {
        for (String child : manager.getDependencies(path)) {
            String ext = BuildManager.getExtension(child);
            if (ext.isEmpty()) continue;
            return ext;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcHash(BuildManager manager, MessageDigest hash, String path, File source) throws IOException, NoSuchAlgorithmException {
        FileReader reader = new FileReader(source);
        try {
            String dependency;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((dependency = lineReader.readLine()) != null) {
                if ((dependency = dependency.trim()).isEmpty() || dependency.startsWith("#")) continue;
                manager.ensureProcessed(dependency);
                String dependencyPath = manager.getProcessedPath(dependency);
                if (dependencyPath == null) {
                    this.log.warn("Missing merge reference: " + dependency);
                    continue;
                }
                manager.addDependency(path, dependency);
                hash.update(dependencyPath.getBytes(CHAR_ENCODING));
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void compact(BuildManager manager, String path, File source, File target) throws IOException {
        this.buildMerge(manager, path, target);
        this.buildDebugPlaceholders(manager, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMerge(BuildManager manager, String path, File target) throws FileNotFoundException, IOException {
        this.log.info("Building " + path);
        String outputPath = manager.getProcessedPath(path);
        if (target.exists()) {
            this.log.info("- exists: " + outputPath);
            return;
        }
        this.log.info("- writing to " + outputPath);
        target.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(target, false);
        try {
            char[] buffer = new char[4096];
            for (String child : manager.getDependencies(path)) {
                this.log.info("- adding " + child);
                File source = manager.getTargetFile(child);
                FileReader reader = new FileReader(source);
                try {
                    int count;
                    while ((count = reader.read(buffer)) > 0) {
                        writer.write(buffer, 0, count);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void buildDebugPlaceholders(BuildManager manager, String path) throws FileNotFoundException, IOException {
        String hashPath = manager.getProcessedPath(path);
        List<String> children = manager.getDependencies(path);
        if (children.size() == 1) {
            manager.setProcessedPath(hashPath, manager.getPlaceholderPath(children.get(0)));
            return;
        }
        int slash = hashPath.lastIndexOf(47);
        String debugPath = hashPath.substring(0, slash) + "/debug" + hashPath.substring(slash);
        manager.setProcessedPath(hashPath, debugPath);
        File target = manager.getTargetFile(hashPath);
        if (target.exists()) {
            return;
        }
        String targetExt = BuildManager.getExtension(hashPath);
        PlaceholderGenerator generator = this.placeholders.get(targetExt);
        if (generator == null) {
            this.log.warn("No debug placeholder generator found for " + targetExt);
            return;
        }
        generator.build(manager, target, children);
    }
}

