/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.Compactor;

class NullCompactor
implements Compactor {
    private static final int BUFFER_SIZE = 4096;
    private final String[] extensions;

    public NullCompactor(String ... extensions) {
        this.extensions = extensions != null ? extensions : new String[]{};
    }

    @Override
    public String[] getSourceExtensions() {
        return this.extensions;
    }

    @Override
    public String getTargetExtension(BuildManager manager, String path) {
        return BuildManager.getExtension(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcHash(BuildManager manager, MessageDigest hash, String path, File source) throws IOException, NoSuchAlgorithmException {
        FileInputStream stream = new FileInputStream(source);
        try {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = stream.read(buffer)) > 0) {
                hash.update(buffer, 0, count);
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(BuildManager manager, String path, File source, File target) throws IOException {
        target.getParentFile().mkdirs();
        FileInputStream inStream = new FileInputStream(source);
        FileOutputStream outStream = new FileOutputStream(target);
        try {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, count);
            }
        }
        finally {
            outStream.flush();
            outStream.close();
            inStream.close();
        }
    }
}

