/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.duelengine.merge.CSSCompactor;
import org.duelengine.merge.CSSPlaceholderGenerator;
import org.duelengine.merge.Compactor;
import org.duelengine.merge.JSCompactor;
import org.duelengine.merge.JSPlaceholderGenerator;
import org.duelengine.merge.MergeCompactor;
import org.duelengine.merge.NullCompactor;
import org.duelengine.merge.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildManager {
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String PROPERTY_LIST_DELIM = "|";
    private static final Logger log = LoggerFactory.getLogger(BuildManager.class);
    private final Map<String, String> hashLookup = new LinkedHashMap<String, String>();
    private final Map<String, List<String>> dependencyMap = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> childLinkMap = new LinkedHashMap<String, List<String>>();
    private final Map<String, Compactor> compactors;
    private final Settings settings;
    private final Stack<String> dependencyChain = new Stack();

    public BuildManager(Settings settings) {
        this(settings, new MergeCompactor(new JSPlaceholderGenerator(), new CSSPlaceholderGenerator()), new NullCompactor(settings.getExtensions()), new CSSCompactor(), new JSCompactor());
    }

    public BuildManager(Settings settings, Compactor ... compactors) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        if (compactors == null) {
            throw new NullPointerException("compactors");
        }
        if (settings.getSourceDir() == null || !settings.getSourceDir().exists()) {
            throw new IllegalArgumentException("Missing source directory " + settings.getSourceDir());
        }
        this.settings = settings;
        this.compactors = new LinkedHashMap<String, Compactor>(compactors.length);
        for (Compactor compactor : compactors) {
            for (String ext : compactor.getSourceExtensions()) {
                this.compactors.put(ext, compactor);
            }
        }
    }

    public void execute() throws IOException, NoSuchAlgorithmException {
        Map<File, String> inputFiles = this.findFiles();
        for (File source : inputFiles.keySet()) {
            this.processResource(inputFiles.get(source), source);
        }
        this.writeCompactionMap();
        this.writeChildLinksMap();
    }

    private boolean isHashCalculated(String path) {
        return this.hashLookup.containsKey(path);
    }

    public String getProcessedPath(String path) {
        return this.hashLookup.get(path);
    }

    public String getPlaceholderPath(String path) {
        String hashed = this.hashLookup.get(path);
        if (hashed == null || hashed.isEmpty()) {
            return path;
        }
        if ((hashed = this.hashLookup.get(hashed)) == null || hashed.isEmpty()) {
            return path;
        }
        return hashed;
    }

    public void setProcessedPath(String path, String hashPath) {
        this.hashLookup.put(path, hashPath);
    }

    private void removeProcessedPath(String path) {
        this.hashLookup.remove(path);
    }

    public void ensureProcessed(String path) {
        if (this.isHashCalculated(path) && this.getTargetFile(path).exists()) {
            return;
        }
        try {
            this.processResource(path, this.settings.findSourceFile(path));
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(String path, File source) throws IOException, NoSuchAlgorithmException {
        if (this.dependencyChain.contains(path)) {
            log.error("Cyclical dependencies detected in: " + path);
            return;
        }
        this.dependencyChain.push(path);
        try {
            File target;
            String sourceExt = BuildManager.getExtension(source.getCanonicalPath());
            Compactor compactor = this.compactors.get(sourceExt);
            if (compactor == null) {
                log.error("No compactor registered for " + sourceExt);
                return;
            }
            if (!this.isHashCalculated(path)) {
                MessageDigest hash = MessageDigest.getInstance(HASH_ALGORITHM);
                if (source != null && source.exists()) {
                    compactor.calcHash(this, hash, path, source);
                }
                String hashPath = BuildManager.encodeBytes(hash.digest());
                String targetExt = compactor.getTargetExtension(this, path);
                this.setProcessedPath(path, this.settings.getCDNRoot() + hashPath + targetExt);
            }
            if (!(target = this.getTargetFile(path)).exists() && source.exists()) {
                target.getParentFile().mkdirs();
                compactor.compact(this, path, source, target);
            }
            if (!target.exists()) {
                log.error(path + " failed to compact (output missing)");
                this.removeProcessedPath(path);
            } else if (target.length() < 1L) {
                if (source.length() < 1L) {
                    log.warn(path + " is an empty file");
                    this.removeProcessedPath(path);
                } else {
                    log.warn(path + " compacted to an empty file (using original for merge)");
                    new NullCompactor(new String[0]).compact(this, path, source, target);
                }
            }
        }
        finally {
            this.dependencyChain.pop();
        }
    }

    public void addChildLink(String path, String child) {
        List<String> children = this.childLinkMap.get(path);
        if (children == null) {
            children = new ArrayList<String>();
            this.childLinkMap.put(path, children);
        }
        if (!children.contains(child)) {
            children.add(child);
        }
    }

    public List<String> getChildLinks(String path) {
        List<String> children = this.childLinkMap.get(path);
        if (children == null) {
            children = Collections.emptyList();
        }
        return children;
    }

    public void addDependency(String path, String dependency) {
        List<String> dependencies = this.dependencyMap.get(path);
        if (dependencies == null) {
            dependencies = new ArrayList<String>();
            this.dependencyMap.put(path, dependencies);
        }
        if (!dependencies.contains(dependency)) {
            dependencies.add(dependency);
        }
    }

    public List<String> getDependencies(String path) {
        List<String> dependencies = this.dependencyMap.get(path);
        if (dependencies == null) {
            dependencies = Collections.emptyList();
        }
        return dependencies;
    }

    public static String getExtension(String path) {
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return path.substring(dot).toLowerCase();
    }

    private static String encodeBytes(byte[] digest) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            int digit = 0xFF & digest[i];
            if (digit < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(digit));
        }
        return hex.toString();
    }

    public File getTargetFile(String path) {
        String outputPath = this.getProcessedPath(path);
        return this.settings.getTargetFile(outputPath);
    }

    private Map<File, String> findFiles() throws IOException {
        Set<String> extensions = this.getExtensions();
        String filterPath = this.settings.getCDNDir().getCanonicalPath();
        LinkedList<File> folders = new LinkedList<File>();
        LinkedHashMap<File, String> files = new LinkedHashMap<File, String>();
        for (File inputDir : new File[]{this.settings.getSourceDir(), this.settings.getTargetDir()}) {
            int rootPrefix = inputDir.getCanonicalPath().length();
            folders.add(inputDir);
            while (!folders.isEmpty()) {
                File file = (File)folders.remove();
                if (file.getCanonicalPath().startsWith(filterPath)) continue;
                if (file.isDirectory()) {
                    folders.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                String ext = BuildManager.getExtension(file.getCanonicalPath());
                if (!extensions.contains(ext)) continue;
                files.put(file, file.getCanonicalPath().substring(rootPrefix));
            }
        }
        return files;
    }

    private Set<String> getExtensions() {
        return this.compactors.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCompactionMap() throws IOException {
        File cdnMapFile = this.settings.getCDNMapFile();
        cdnMapFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(cdnMapFile, false);
        try {
            this.writeCompactionMap(writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void writeCompactionMap(Appendable output) throws IOException {
        for (String key : this.hashLookup.keySet()) {
            String value = this.hashLookup.get(key);
            value = BuildManager.escapePropertyValue(value);
            output.append(key).append('=').append(value).append(NEWLINE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChildLinksMap() throws IOException {
        File cdnLinksFile = this.settings.getCDNLinksFile();
        cdnLinksFile.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(cdnLinksFile, false);
        try {
            this.writeChildLinksMap(writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private void writeChildLinksMap(Appendable output) throws IOException {
        for (String path : this.dependencyMap.keySet()) {
            this.addTransitiveChildLinks(path);
        }
        for (String key : this.childLinkMap.keySet()) {
            List<String> children = this.childLinkMap.get(key);
            boolean needsDelim = false;
            output.append(key).append('=');
            for (String child : children) {
                if (needsDelim) {
                    output.append(PROPERTY_LIST_DELIM);
                } else {
                    needsDelim = true;
                }
                output.append(BuildManager.escapePropertyValue(child));
            }
            output.append(NEWLINE);
        }
    }

    private void addTransitiveChildLinks(String path) {
        if (!this.dependencyMap.containsKey(path)) {
            return;
        }
        List<String> dependencies = this.dependencyMap.get(path);
        for (String dependency : dependencies) {
            this.addTransitiveChildLinks(dependency);
            if (!this.childLinkMap.containsKey(dependency)) continue;
            List<String> children = this.childLinkMap.get(dependency);
            for (String child : children) {
                this.addChildLink(path, child);
                log.info("transitive child link: " + path + "=>" + child);
            }
        }
    }

    private static String escapePropertyValue(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder output = null;
        int start = 0;
        int length = value.length();
        block3: for (int i = start; i < length; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    if (output == null) {
                        output = new StringBuilder(length * 2);
                    }
                    if (i > start) {
                        output.append(value, start, i);
                    }
                    start = i + 1;
                    output.append('\\').append(ch);
                    continue block3;
                }
            }
        }
        if (output == null) {
            return value;
        }
        if (length > start) {
            output.append(value, start, length);
        }
        return output.toString();
    }
}

