/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.PlaceholderGenerator;

public class CSSPlaceholderGenerator
implements PlaceholderGenerator {
    @Override
    public String getTargetExtension() {
        return ".css";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(BuildManager manager, File target, List<String> children) throws IOException {
        String nocache = '?' + target.getName();
        int dot = target.getName().lastIndexOf(46);
        if (dot > 0) {
            nocache = nocache.substring(0, dot);
        }
        target.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(target, false);
        try {
            writer.append("/* simulate semantics of merged stylesheets but allow debugging of original files; append anti-caching suffix */\n");
            for (String child : children) {
                child = manager.getPlaceholderPath(child);
                writer.append("@import url(").append(child).append(nocache).append(");\n");
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }
}

