/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.PlaceholderGenerator;

public class JSPlaceholderGenerator
implements PlaceholderGenerator {
    @Override
    public String getTargetExtension() {
        return ".js";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(BuildManager manager, File target, List<String> children) throws IOException {
        String nocache = '?' + target.getName();
        int dot = target.getName().lastIndexOf(46);
        if (dot > 0) {
            nocache = nocache.substring(0, dot);
        }
        target.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(target, false);
        try {
            writer.append("(function() {\n").append("\t// simulate semantics of merged scripts but allow debugging the original files; append anti-caching suffix\n").append("\ttry {\n");
            for (String child : children) {
                child = manager.getPlaceholderPath(child);
                writer.append("\t\tdocument.write('\\u003cscript type=\"text/javascript\" src=\"").append(child.replace("'", "\\'") + nocache).append("\">\\u003c/script>');\n");
            }
            writer.append("\t} catch(ex) {\n").append("\t\tvar s, d=document, f=d.getElementsByTagName('script')[0], p=f.parentNode;\n");
            for (String child : children) {
                child = manager.getPlaceholderPath(child);
                writer.append("\t\ts=d.createElement('script');s.type='text/javascript';s.src='").append(child.replace("'", "\\'")).append(nocache).append("';p.insertBefore(s,f);\n");
            }
            writer.append("\t}\n").append("})();");
        }
        finally {
            writer.flush();
            writer.close();
        }
    }
}

