/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.Compactor;

class NullCompactor
implements Compactor {
    private static final int BUFFER_SIZE = 4096;
    private final String[] extensions;
    private byte[] buffer;

    public NullCompactor(String ... extensions) {
        this.extensions = extensions != null ? extensions : new String[]{};
    }

    @Override
    public String[] getSourceExtensions() {
        return this.extensions;
    }

    @Override
    public String getTargetExtension(BuildManager manager, String path) {
        return BuildManager.getExtension(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcHash(BuildManager manager, MessageDigest hash, String path, File source) throws IOException, NoSuchAlgorithmException {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        FileInputStream stream = new FileInputStream(source);
        try {
            int count;
            while ((count = stream.read(this.buffer)) > 0) {
                hash.update(this.buffer, 0, count);
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(BuildManager manager, String path, File source, File target) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        target.getParentFile().mkdirs();
        FileInputStream inStream = new FileInputStream(source);
        FileOutputStream outStream = new FileOutputStream(target);
        try {
            int count;
            while ((count = inStream.read(this.buffer)) > 0) {
                outStream.write(this.buffer, 0, count);
            }
        }
        finally {
            outStream.flush();
            outStream.close();
            inStream.close();
        }
    }
}

