/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.FunctionNode;
import org.duelengine.css.ast.StringNode;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.codegen.CssFilter;
import org.duelengine.css.codegen.CssFormatter;
import org.duelengine.css.parsing.CssLexer;
import org.duelengine.merge.BuildManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkInterceptorCssFilter
implements CssFilter {
    private static final Logger log = LoggerFactory.getLogger(LinkInterceptorCssFilter.class);
    private static final CssFormatter cssFormatter = new CssFormatter();
    private final BuildManager manager;
    private final String path;

    public LinkInterceptorCssFilter(BuildManager manager, String path) {
        this.manager = manager;
        this.path = path;
    }

    public CssNode filter(CssNode node) {
        if (node.getNodeType() != CssNodeType.FUNCTION) {
            return node;
        }
        FunctionNode func = (FunctionNode)node;
        if (!"url".equals(func.getValue())) {
            return node;
        }
        ContainerNode children = func.getContainer();
        if (children.childCount() > 1) {
            StringBuilder buffer = new StringBuilder();
            try {
                cssFormatter.writeNode((Appendable)buffer, (CssNode)children, null);
            }
            catch (IOException e) {
                return node;
            }
            String value = buffer.toString();
            if (value == null || value.isEmpty()) {
                return node;
            }
            children.getChildren().clear();
            children.getChildren().add(new ValueNode(value));
        }
        for (CssNode child : children.getChildren()) {
            if (child instanceof ValueNode) {
                ValueNode valNode = (ValueNode)child;
                String val = valNode.getValue();
                if ((val = CssLexer.decodeString((String)val)) == null || val.isEmpty() || val.startsWith("data:")) break;
                String suffix = "";
                if (val.charAt(0) != '/') {
                    URI uri;
                    URI context = this.getContextPath(this.path);
                    if (context != null && (uri = context.resolve(val)).getHost() == null && uri.getScheme() == null) {
                        val = uri.getPath();
                        if (uri.getQuery() != null) {
                            suffix = suffix + '?' + uri.getQuery();
                        }
                        if (uri.getFragment() != null) {
                            suffix = suffix + '#' + uri.getFragment();
                        }
                    }
                } else {
                    int hash;
                    int query = val.indexOf(63);
                    if (query >= 0) {
                        suffix = suffix + val.substring(query);
                        val = val.substring(0, query);
                    }
                    if ((hash = val.indexOf(35)) >= 0) {
                        suffix = suffix + val.substring(hash);
                        val = val.substring(0, hash);
                    }
                }
                this.manager.addChildLink(this.path, val);
                this.manager.ensureProcessed(val);
                String valHash = this.manager.getProcessedPath(val);
                if (valHash == null) {
                    log.warn("Missing CSS reference: " + val);
                    break;
                }
                valHash = valHash.substring(valHash.lastIndexOf(47) + 1);
                val = val + suffix;
                valHash = valHash + suffix;
                if (child instanceof StringNode) {
                    valHash = CssLexer.encodeString((String)valHash);
                }
                valNode.setValue(valHash);
                log.info("CSS url: " + val + " => " + valHash);
                continue;
            }
            log.warn("Unexpected CSS url type: " + child.getNodeType());
        }
        return node;
    }

    private URI getContextPath(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }
}

