/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge.maven;

import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.duelengine.merge.BuildManager;
import org.duelengine.merge.Settings;
import org.duelengine.merge.maven.MavenLoggerAdapterFactory;

public class MergeMojo
extends AbstractMojo {
    private String webappDir;
    private String outputDir;
    private String resourcesDir;
    private String cdnRoot;
    private String cdnMapFile;
    private String cdnFiles;

    public void setLog(Log log) {
        super.setLog(log);
        MavenLoggerAdapterFactory.setMavenLogger(log);
    }

    public void execute() throws MojoExecutionException {
        Settings settings = new Settings();
        settings.setSourceDir(this.webappDir);
        settings.setTargetDir(this.outputDir);
        settings.setCDNMapFile(this.resourcesDir + this.cdnMapFile);
        settings.setCDNRoot(this.cdnRoot);
        settings.setExtensionList(this.cdnFiles);
        Log log = this.getLog();
        log.info((CharSequence)("\tsourceDir=" + settings.getSourceDir()));
        log.info((CharSequence)("\ttargetDir=" + settings.getTargetDir()));
        log.info((CharSequence)("\tcdnMapFile=" + settings.getCDNMapFile()));
        log.info((CharSequence)("\tcdnRoot=" + settings.getCDNRoot()));
        log.info((CharSequence)("\tcdnFiles=" + Arrays.toString(settings.getExtensions())));
        try {
            new BuildManager(settings).execute();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }
}

