/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.account.config;

import org.duracloud.common.model.EmailerType;

/**
 * Configuration properties for the Management Console
 *
 * @author Bill Branan
 * Date: 6/18/14
 */
public class McConfig {

    private String mcHost;
    private String mcPort;
    private String mcContext;
    private String mcDomain;

    private EmailerType emailerType;
    private String notificationUser;
    private String notificationPass;
    private String notificationHost;
    private String notificationPort;
    private String notificationFromAddress;
    private String notificationAdminAddress;

    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbUser;
    private String dbPass;

    public McConfig(String mcHost,
                    String mcPort,
                    String mcContext,
                    String mcDomain,
                    String emailerType,
                    String notificationUser,
                    String notificationPass,
                    String notificationHost,
                    String notificationPort,
                    String notificationFromAddress,
                    String notificationAdminAddress,
                    String dbHost,
                    String dbPort,
                    String dbName,
                    String dbUser,
                    String dbPass) {
        this.mcHost = mcHost;
        this.mcPort = mcPort;
        this.mcContext = mcContext;
        this.mcDomain = mcDomain;
        this.emailerType = EmailerType.fromString(emailerType.trim());
        this.notificationUser = notificationUser;
        this.notificationPass = notificationPass;
        this.notificationHost = notificationHost;
        // Initialise a default port if non specified
        if (notificationPort.isEmpty()) {
            this.notificationPort = "25";
        } else {
            this.notificationPort = notificationPort;
        }
        this.notificationFromAddress = notificationFromAddress;
        this.notificationAdminAddress = notificationAdminAddress;
        this.dbHost = dbHost;
        this.dbPort = dbPort;
        this.dbName = dbName;
        this.dbUser = dbUser;
        this.dbPass = dbPass;
    }

    public String getMcHost() {
        return mcHost;
    }

    public String getMcPort() {
        return mcPort;
    }

    public String getMcContext() {
        return mcContext;
    }

    public String getMcDomain() {
        return mcDomain;
    }

    public EmailerType getEmailerType() {
        return emailerType;
    }

    public String getNotificationUser() {
        return notificationUser;
    }

    public String getNotificationPass() {
        return notificationPass;
    }

    public String getNotificationHost() {
        return notificationHost;
    }

    public String getNotificationPort() {
        return notificationPort;
    }

    public String getNotificationFromAddress() {
        return notificationFromAddress;
    }

    public String getNotificationAdminAddress() {
        return notificationAdminAddress;
    }

    public String getDbHost() {
        return dbHost;
    }

    public String getDbPort() {
        return dbPort;
    }

    public String getDbName() {
        return dbName;
    }

    public String getDbUser() {
        return dbUser;
    }

    public String getDbPass() {
        return dbPass;
    }
}
