/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.compute;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AssociateAddressResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.duracloud.account.compute.AmazonComputeConnector;
import org.duracloud.account.compute.DuracloudComputeProvider;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.compute.error.InstanceStartupException;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonComputeProvider
implements DuracloudComputeProvider {
    private Logger log = LoggerFactory.getLogger(AmazonComputeProvider.class);
    private static final int STARTUP_WAIT_TIME = 300000;
    private static final int SLEEP_TIME = 5000;
    private AmazonEC2Client ec2Client;
    private AmazonIdentityManagementClient iamClient;

    public AmazonComputeProvider(String accessKey, String secretKey) {
        this.ec2Client = AmazonComputeConnector.getAmazonEC2Client(accessKey, secretKey);
        this.iamClient = new AmazonIdentityManagementClient((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
    }

    protected AmazonComputeProvider(AmazonEC2Client ec2Client, AmazonIdentityManagementClient iamClient) {
        this.ec2Client = ec2Client;
        this.iamClient = iamClient;
    }

    public String start(String providerImageId, String iamRole, String securityGroup, String keyname, String elasticIp, InstanceType instanceType, String instanceName) {
        return this.doStart(providerImageId, iamRole, securityGroup, keyname, elasticIp, true, instanceType, instanceName);
    }

    protected String doStart(String providerImageId, String iamRole, String securityGroup, String keyname, String elasticIp, boolean wait, InstanceType instanceType, String instanceName) {
        RunInstancesResult result;
        this.stopExistingInstances(elasticIp);
        String zone = "us-east-1d";
        try {
            result = this.doRun(providerImageId, iamRole, securityGroup, keyname, zone, true, instanceType, instanceName);
        }
        catch (AmazonServiceException e) {
            this.log.warn("Error attempting to start instance: {}. Attempting again with no zone setting.", (Object)e.getMessage());
            result = this.doRun(providerImageId, iamRole, securityGroup, keyname, null, false, instanceType, instanceName);
        }
        String instanceId = ((Instance)result.getReservation().getInstances().iterator().next()).getInstanceId();
        if (wait) {
            try {
                if (this.waitInstanceRunning(instanceId, 300000L)) {
                    if (!this.waitInstanceRunning(instanceId, 300000L)) {
                        this.startError(instanceId);
                    }
                } else {
                    this.startError(instanceId);
                }
            }
            catch (DuracloudInstanceNotAvailableException e) {
                this.startError(instanceId);
            }
        }
        this.associateAddress(elasticIp, instanceId);
        this.log.info("Instance started successfully and IP {} attached", (Object)elasticIp);
        return instanceId;
    }

    private RunInstancesResult doRun(String providerImageId, String iamRole, String securityGroup, String keyname, String availabilityZone, boolean includeZone, InstanceType instanceType, String instanceName) {
        RunInstancesRequest request = new RunInstancesRequest(providerImageId, Integer.valueOf(1), Integer.valueOf(1));
        HashSet<String> securityGroups = new HashSet<String>();
        securityGroups.add(securityGroup);
        request.setSecurityGroups(securityGroups);
        request.setKeyName(keyname);
        request.setInstanceType(this.convertDuracloudInstanceTypeToNative(instanceType));
        IamInstanceProfileSpecification iamProfileSpec = this.getIamProfileSpec(iamRole);
        if (null != iamProfileSpec) {
            request.setIamInstanceProfile(iamProfileSpec);
        }
        if (includeZone) {
            request.setPlacement(new Placement(availabilityZone));
        }
        RunInstancesResult result = this.ec2Client.runInstances(request);
        if (instanceName != null) {
            String instanceId = ((Instance)result.getReservation().getInstances().get(0)).getInstanceId();
            CreateTagsRequest createTagsRequest = new CreateTagsRequest();
            createTagsRequest.withResources(new String[]{instanceId}).withTags(new Tag[]{new Tag("Name", instanceName)});
            this.ec2Client.createTags(createTagsRequest);
        }
        return result;
    }

    private IamInstanceProfileSpecification getIamProfileSpec(String iamRole) {
        if (null != iamRole) {
            InstanceProfile instanceProfile;
            try {
                GetInstanceProfileResult getProfileResult = this.iamClient.getInstanceProfile(new GetInstanceProfileRequest().withInstanceProfileName(iamRole));
                instanceProfile = getProfileResult.getInstanceProfile();
            }
            catch (NoSuchEntityException e) {
                CreateInstanceProfileResult createProfileResult = this.iamClient.createInstanceProfile(new CreateInstanceProfileRequest().withInstanceProfileName(iamRole));
                instanceProfile = createProfileResult.getInstanceProfile();
            }
            if (null != instanceProfile) {
                return new IamInstanceProfileSpecification().withName(instanceProfile.getInstanceProfileName());
            }
        }
        return null;
    }

    private void stopExistingInstances(String elasticIp) {
        DescribeAddressesRequest describeAddressesRequest = new DescribeAddressesRequest().withPublicIps(new String[]{elasticIp});
        try {
            DescribeAddressesResult result = this.ec2Client.describeAddresses(describeAddressesRequest);
            if (null != result) {
                List addresses = result.getAddresses();
                for (Address address : addresses) {
                    String instanceId = address.getInstanceId();
                    if (null == instanceId || instanceId.isEmpty()) continue;
                    this.log.warn("Shutting down instance with ID {} because it was associated with elastic IP {}", (Object)instanceId, (Object)elasticIp);
                    this.stop(instanceId);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error attempting to stop instance associated with elastic IP {}: {}", (Object)elasticIp, (Object)e.getMessage());
        }
    }

    private void associateAddress(String elasticIp, String instanceId) {
        this.log.debug("Associating elastic IP {} with instance {}", (Object)elasticIp, (Object)instanceId);
        AssociateAddressRequest associateRequest = new AssociateAddressRequest(instanceId, elasticIp);
        int maxTries = 5;
        int tries = 0;
        Exception e = null;
        AssociateAddressResult result = null;
        while (tries++ < 5 && null == result) {
            try {
                result = this.ec2Client.associateAddress(associateRequest);
            }
            catch (Exception ex) {
                e = ex;
                this.sleep(5000 * tries);
            }
        }
        if (null == result && null != e) {
            StringBuilder error = new StringBuilder();
            error.append("Error associating ip address: " + associateRequest);
            this.log.error(error.toString());
            throw new InstanceStartupException(error.toString(), e);
        }
    }

    private void startError(String instanceId) {
        this.stop(instanceId);
        String err = "Instance with ID " + instanceId + " did not start within " + 5 + " minutes. The instance has been shut down.";
        throw new InstanceStartupException(err);
    }

    public boolean waitInstanceRunning(String instanceId, long timeout) throws DuracloudInstanceNotAvailableException {
        long start = System.currentTimeMillis();
        while (!InstanceState.RUNNING.getValue().equals(this.getStatus(instanceId))) {
            long now = System.currentTimeMillis();
            if (now - start > timeout) {
                this.log.warn("EC2 instance with ID " + instanceId + " was not available prior to wait timeout of " + timeout + " milliseconds.");
                return false;
            }
            this.sleep(5000);
        }
        return true;
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop(String providerInstanceId) {
        List<String> instanceIds = this.getIdList(providerInstanceId);
        TerminateInstancesRequest request = new TerminateInstancesRequest();
        request.setInstanceIds(instanceIds);
        this.ec2Client.terminateInstances(request);
    }

    public void restart(String providerInstanceId) {
        List<String> instanceIds = this.getIdList(providerInstanceId);
        RebootInstancesRequest request = new RebootInstancesRequest();
        request.setInstanceIds(instanceIds);
        this.ec2Client.rebootInstances(request);
    }

    public String getStatus(String providerInstanceId) throws DuracloudInstanceNotAvailableException {
        if (providerInstanceId.equals(DuracloudInstance.PLACEHOLDER_PROVIDER_ID)) {
            return InstanceState.STARTING.getValue();
        }
        DescribeInstancesResult result = this.describeInstance(providerInstanceId);
        try {
            return ((Instance)((Reservation)result.getReservations().iterator().next()).getInstances().iterator().next()).getState().getName();
        }
        catch (Exception e) {
            this.log.error("Unable to get status for EC2 instance with ID " + providerInstanceId + " due to error: " + e.getMessage(), (Throwable)e);
            return "unknown";
        }
    }

    private DescribeInstancesResult describeInstance(String providerInstanceId) throws DuracloudInstanceNotAvailableException {
        List<String> instanceIds = this.getIdList(providerInstanceId);
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(instanceIds);
        int maxTries = 5;
        int tries = 0;
        Exception e = null;
        DescribeInstancesResult result = null;
        while (tries++ < 5 && null == result) {
            try {
                result = this.ec2Client.describeInstances(request);
            }
            catch (Exception ex) {
                e = ex;
                this.sleep(5000 * tries);
            }
        }
        if (null == result && null != e) {
            StringBuilder error = new StringBuilder();
            error.append("Error describing instance: " + providerInstanceId);
            error.append(e);
            this.log.error(error.toString());
            throw new DuracloudInstanceNotAvailableException(error.toString(), (Throwable)e);
        }
        return result;
    }

    private List<String> getIdList(String id) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        return ids;
    }

    public InstanceType getInstanceType(String providerInstanceId) throws DuracloudInstanceNotAvailableException {
        DescribeInstancesResult result = this.describeInstance(providerInstanceId);
        try {
            String instanceType = ((Instance)((Reservation)result.getReservations().iterator().next()).getInstances().iterator().next()).getInstanceType();
            for (InstanceType it : InstanceType.values()) {
                if (!this.convertDuracloudInstanceTypeToNative(it).equals(instanceType)) continue;
                return it;
            }
            String message = "Unable to get instance type for EC2 instance with ID " + providerInstanceId + ": amazon instance type '" + instanceType + "' unknown to DuraCloud MC.";
            throw new DuraCloudRuntimeException(message);
        }
        catch (Exception e) {
            String message = "Unable to get instance type for EC2 instance with ID " + providerInstanceId + " due to error: " + e.getMessage();
            this.log.error(message, (Throwable)e);
            throw new DuraCloudRuntimeException(message, (Throwable)e);
        }
    }

    protected String convertDuracloudInstanceTypeToNative(InstanceType it) {
        if (it.equals((Object)InstanceType.SMALL)) {
            return "m1." + it.name().toLowerCase();
        }
        return "m3." + it.name().toLowerCase();
    }

    private static enum InstanceState {
        PENDING("pending"),
        RUNNING("running"),
        SHUTTING_DOWN("shutting-down"),
        TERMINATED("terminated"),
        STARTING("starting");

        private String value;

        private InstanceState(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

