/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.model;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.duracloud.account.db.model.AccountCluster;
import org.duracloud.account.db.model.AccountType;
import org.duracloud.account.db.model.BaseEntity;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.ServerDetails;

@Entity
public class AccountInfo
extends BaseEntity
implements Comparable<AccountInfo> {
    private String subdomain;
    private String acctName;
    private String orgName;
    private String department;
    @Enumerated(value=EnumType.STRING)
    private AccountStatus status;
    @Enumerated(value=EnumType.STRING)
    private AccountType type;
    @OneToOne(fetch=FetchType.EAGER, optional=true, cascade={CascadeType.ALL})
    @JoinColumn(name="server_details_id", nullable=true, columnDefinition="bigint(20)")
    private ServerDetails serverDetails;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    @JoinColumn(name="account_cluster_id", nullable=true, columnDefinition="bigint(20)")
    private AccountCluster accountCluster;
    @OneToOne(fetch=FetchType.EAGER, optional=true, mappedBy="account")
    private DuracloudInstance instance;

    public DuracloudInstance getInstance() {
        return this.instance;
    }

    public void setInstance(DuracloudInstance instance) {
        this.instance = instance;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public String getAcctName() {
        return this.acctName;
    }

    public void setAcctName(String acctName) {
        this.acctName = acctName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public ServerDetails getServerDetails() {
        return this.serverDetails;
    }

    public void setServerDetails(ServerDetails serverDetails) {
        this.serverDetails = serverDetails;
    }

    public AccountCluster getAccountCluster() {
        return this.accountCluster;
    }

    public void setAccountCluster(AccountCluster accountCluster) {
        this.accountCluster = accountCluster;
    }

    @Override
    public int compareTo(AccountInfo o) {
        return this.acctName.compareTo(o.acctName);
    }

    public static enum AccountStatus {
        PENDING,
        ACTIVE,
        INACTIVE;

    }
}

