/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.PushSync;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SetIdentityPoolConfigurationRequestMarshaller
implements Marshaller<Request<SetIdentityPoolConfigurationRequest>, SetIdentityPoolConfigurationRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<SetIdentityPoolConfigurationRequest> marshall(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        if (setIdentityPoolConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetIdentityPoolConfigurationRequest> request = new DefaultRequest<SetIdentityPoolConfigurationRequest>(setIdentityPoolConfigurationRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.SetIdentityPoolConfiguration";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("IdentityPoolId")) {
            String value;
            String name = DYNAMIC_QUERY_PARAMS.get("IdentityPoolId");
            String string = value = setIdentityPoolConfigurationRequest.getIdentityPoolId() == null ? null : StringUtils.fromString(setIdentityPoolConfigurationRequest.getIdentityPoolId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", setIdentityPoolConfigurationRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(setIdentityPoolConfigurationRequest.getIdentityPoolId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            PushSync pushSync = setIdentityPoolConfigurationRequest.getPushSync();
            if (pushSync != null) {
                jsonWriter.key("PushSync");
                jsonWriter.object();
                ListWithAutoConstructFlag applicationArnsList = (ListWithAutoConstructFlag)pushSync.getApplicationArns();
                if (!(applicationArnsList == null || applicationArnsList.isAutoConstruct() && applicationArnsList.isEmpty())) {
                    jsonWriter.key("ApplicationArns");
                    jsonWriter.array();
                    for (String applicationArnsListValue : applicationArnsList) {
                        if (applicationArnsListValue == null) continue;
                        jsonWriter.value(applicationArnsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (pushSync.getRoleArn() != null) {
                    jsonWriter.key("RoleArn").value(pushSync.getRoleArn());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/identitypools/{IdentityPoolId}/configuration";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

