/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.SourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Event
implements Serializable {
    private String sourceIdentifier;
    private String sourceType;
    private String message;
    private ListWithAutoConstructFlag<String> eventCategories;
    private String severity;
    private Date date;
    private String eventId;

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public Event withSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Event withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
    }

    public Event withSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Event withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new ListWithAutoConstructFlag();
            this.eventCategories.setAutoConstruct(true);
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
        eventCategoriesCopy.addAll(eventCategories);
        this.eventCategories = eventCategoriesCopy;
    }

    public Event withEventCategories(String ... eventCategories) {
        if (this.getEventCategories() == null) {
            this.setEventCategories(new ArrayList<String>(eventCategories.length));
        }
        for (String value : eventCategories) {
            this.getEventCategories().add(value);
        }
        return this;
    }

    public Event withEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
        } else {
            ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
            eventCategoriesCopy.addAll(eventCategories);
            this.eventCategories = eventCategoriesCopy;
        }
        return this;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public Event withSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Event withDate(Date date) {
        this.date = date;
        return this;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Event withEventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceIdentifier() != null) {
            sb.append("SourceIdentifier: " + this.getSourceIdentifier() + ",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: " + this.getSourceType() + ",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: " + this.getEventCategories() + ",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: " + this.getSeverity() + ",");
        }
        if (this.getDate() != null) {
            sb.append("Date: " + this.getDate() + ",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: " + this.getEventId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceIdentifier() == null ? 0 : this.getSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : this.getEventCategories().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getDate() == null ? 0 : this.getDate().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getSourceIdentifier() == null ^ this.getSourceIdentifier() == null) {
            return false;
        }
        if (other.getSourceIdentifier() != null && !other.getSourceIdentifier().equals(this.getSourceIdentifier())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !other.getEventCategories().equals(this.getEventCategories())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getDate() == null ^ this.getDate() == null) {
            return false;
        }
        if (other.getDate() != null && !other.getDate().equals(this.getDate())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        return other.getEventId() == null || other.getEventId().equals(this.getEventId());
    }
}

