/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DeleteAssociationRequestMarshaller
implements Marshaller<Request<DeleteAssociationRequest>, DeleteAssociationRequest> {
    @Override
    public Request<DeleteAssociationRequest> marshall(DeleteAssociationRequest deleteAssociationRequest) {
        if (deleteAssociationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAssociationRequest> request = new DefaultRequest<DeleteAssociationRequest>(deleteAssociationRequest, "AWSSimpleSystemsManagement");
        String target = "AmazonSSM.DeleteAssociation";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteAssociationRequest.getName() != null) {
                jsonWriter.key("Name").value(deleteAssociationRequest.getName());
            }
            if (deleteAssociationRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(deleteAssociationRequest.getInstanceId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

