/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSQSAsyncClient
extends AmazonSQSClient
implements AmazonSQSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonSQSAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonSQSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonSQSAsyncClientBuilder asyncBuilder() {
        return AmazonSQSAsyncClientBuilder.standard();
    }

    AmazonSQSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request) {
        return this.addPermissionAsync(request, null);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request, final AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        final AddPermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                AddPermissionResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeAddPermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        return this.addPermissionAsync(new AddPermissionRequest().withQueueUrl(queueUrl).withLabel(label).withAWSAccountIds(aWSAccountIds).withActions(actions));
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions, AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.addPermissionAsync(new AddPermissionRequest().withQueueUrl(queueUrl).withLabel(label).withAWSAccountIds(aWSAccountIds).withActions(actions), asyncHandler);
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(ChangeMessageVisibilityRequest request) {
        return this.changeMessageVisibilityAsync(request, null);
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(ChangeMessageVisibilityRequest request, final AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> asyncHandler) {
        final ChangeMessageVisibilityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ChangeMessageVisibilityResult>(){

            @Override
            public ChangeMessageVisibilityResult call() throws Exception {
                ChangeMessageVisibilityResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeChangeMessageVisibility(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeMessageVisibilityAsync(new ChangeMessageVisibilityRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle).withVisibilityTimeout(visibilityTimeout));
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(String queueUrl, String receiptHandle, Integer visibilityTimeout, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> asyncHandler) {
        return this.changeMessageVisibilityAsync(new ChangeMessageVisibilityRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle).withVisibilityTimeout(visibilityTimeout), asyncHandler);
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(ChangeMessageVisibilityBatchRequest request) {
        return this.changeMessageVisibilityBatchAsync(request, null);
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(ChangeMessageVisibilityBatchRequest request, final AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) {
        final ChangeMessageVisibilityBatchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ChangeMessageVisibilityBatchResult>(){

            @Override
            public ChangeMessageVisibilityBatchResult call() throws Exception {
                ChangeMessageVisibilityBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeChangeMessageVisibilityBatch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        return this.changeMessageVisibilityBatchAsync(new ChangeMessageVisibilityBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries, AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) {
        return this.changeMessageVisibilityBatchAsync(new ChangeMessageVisibilityBatchRequest().withQueueUrl(queueUrl).withEntries(entries), asyncHandler);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request) {
        return this.createQueueAsync(request, null);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest request, final AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) {
        final CreateQueueRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                CreateQueueResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeCreateQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(String queueName) {
        return this.createQueueAsync(new CreateQueueRequest().withQueueName(queueName));
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(String queueName, AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) {
        return this.createQueueAsync(new CreateQueueRequest().withQueueName(queueName), asyncHandler);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest request) {
        return this.deleteMessageAsync(request, null);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest request, final AsyncHandler<DeleteMessageRequest, DeleteMessageResult> asyncHandler) {
        final DeleteMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMessageResult>(){

            @Override
            public DeleteMessageResult call() throws Exception {
                DeleteMessageResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeDeleteMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(String queueUrl, String receiptHandle) {
        return this.deleteMessageAsync(new DeleteMessageRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle));
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(String queueUrl, String receiptHandle, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> asyncHandler) {
        return this.deleteMessageAsync(new DeleteMessageRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle), asyncHandler);
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(DeleteMessageBatchRequest request) {
        return this.deleteMessageBatchAsync(request, null);
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(DeleteMessageBatchRequest request, final AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) {
        final DeleteMessageBatchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMessageBatchResult>(){

            @Override
            public DeleteMessageBatchResult call() throws Exception {
                DeleteMessageBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeDeleteMessageBatch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        return this.deleteMessageBatchAsync(new DeleteMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(String queueUrl, List<DeleteMessageBatchRequestEntry> entries, AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) {
        return this.deleteMessageBatchAsync(new DeleteMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries), asyncHandler);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request) {
        return this.deleteQueueAsync(request, null);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest request, final AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) {
        final DeleteQueueRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteQueueResult>(){

            @Override
            public DeleteQueueResult call() throws Exception {
                DeleteQueueResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeDeleteQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(String queueUrl) {
        return this.deleteQueueAsync(new DeleteQueueRequest().withQueueUrl(queueUrl));
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(String queueUrl, AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) {
        return this.deleteQueueAsync(new DeleteQueueRequest().withQueueUrl(queueUrl), asyncHandler);
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(GetQueueAttributesRequest request) {
        return this.getQueueAttributesAsync(request, null);
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(GetQueueAttributesRequest request, final AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) {
        final GetQueueAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                GetQueueAttributesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeGetQueueAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributesAsync(new GetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributeNames(attributeNames));
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(String queueUrl, List<String> attributeNames, AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) {
        return this.getQueueAttributesAsync(new GetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributeNames(attributeNames), asyncHandler);
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(GetQueueUrlRequest request) {
        return this.getQueueUrlAsync(request, null);
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(GetQueueUrlRequest request, final AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) {
        final GetQueueUrlRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueueUrlResult>(){

            @Override
            public GetQueueUrlResult call() throws Exception {
                GetQueueUrlResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeGetQueueUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(String queueName) {
        return this.getQueueUrlAsync(new GetQueueUrlRequest().withQueueName(queueName));
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(String queueName, AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) {
        return this.getQueueUrlAsync(new GetQueueUrlRequest().withQueueName(queueName), asyncHandler);
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(ListDeadLetterSourceQueuesRequest request) {
        return this.listDeadLetterSourceQueuesAsync(request, null);
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(ListDeadLetterSourceQueuesRequest request, final AsyncHandler<ListDeadLetterSourceQueuesRequest, ListDeadLetterSourceQueuesResult> asyncHandler) {
        final ListDeadLetterSourceQueuesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeadLetterSourceQueuesResult>(){

            @Override
            public ListDeadLetterSourceQueuesResult call() throws Exception {
                ListDeadLetterSourceQueuesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeListDeadLetterSourceQueues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request) {
        return this.listQueuesAsync(request, null);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request, final AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        final ListQueuesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                ListQueuesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeListQueues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync() {
        return this.listQueuesAsync(new ListQueuesRequest());
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        return this.listQueuesAsync(new ListQueuesRequest(), asyncHandler);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(String queueNamePrefix) {
        return this.listQueuesAsync(new ListQueuesRequest().withQueueNamePrefix(queueNamePrefix));
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(String queueNamePrefix, AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        return this.listQueuesAsync(new ListQueuesRequest().withQueueNamePrefix(queueNamePrefix), asyncHandler);
    }

    @Override
    public Future<PurgeQueueResult> purgeQueueAsync(PurgeQueueRequest request) {
        return this.purgeQueueAsync(request, null);
    }

    @Override
    public Future<PurgeQueueResult> purgeQueueAsync(PurgeQueueRequest request, final AsyncHandler<PurgeQueueRequest, PurgeQueueResult> asyncHandler) {
        final PurgeQueueRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurgeQueueResult>(){

            @Override
            public PurgeQueueResult call() throws Exception {
                PurgeQueueResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executePurgeQueue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest request) {
        return this.receiveMessageAsync(request, null);
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest request, final AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) {
        final ReceiveMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                ReceiveMessageResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeReceiveMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(String queueUrl) {
        return this.receiveMessageAsync(new ReceiveMessageRequest().withQueueUrl(queueUrl));
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(String queueUrl, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) {
        return this.receiveMessageAsync(new ReceiveMessageRequest().withQueueUrl(queueUrl), asyncHandler);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        final RemovePermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeRemovePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String queueUrl, String label) {
        return this.removePermissionAsync(new RemovePermissionRequest().withQueueUrl(queueUrl).withLabel(label));
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String queueUrl, String label, AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.removePermissionAsync(new RemovePermissionRequest().withQueueUrl(queueUrl).withLabel(label), asyncHandler);
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(SendMessageRequest request) {
        return this.sendMessageAsync(request, null);
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(SendMessageRequest request, final AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) {
        final SendMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                SendMessageResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeSendMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(String queueUrl, String messageBody) {
        return this.sendMessageAsync(new SendMessageRequest().withQueueUrl(queueUrl).withMessageBody(messageBody));
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(String queueUrl, String messageBody, AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) {
        return this.sendMessageAsync(new SendMessageRequest().withQueueUrl(queueUrl).withMessageBody(messageBody), asyncHandler);
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(SendMessageBatchRequest request) {
        return this.sendMessageBatchAsync(request, null);
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(SendMessageBatchRequest request, final AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) {
        final SendMessageBatchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendMessageBatchResult>(){

            @Override
            public SendMessageBatchResult call() throws Exception {
                SendMessageBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeSendMessageBatch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.sendMessageBatchAsync(new SendMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(String queueUrl, List<SendMessageBatchRequestEntry> entries, AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) {
        return this.sendMessageBatchAsync(new SendMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries), asyncHandler);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(SetQueueAttributesRequest request) {
        return this.setQueueAttributesAsync(request, null);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(SetQueueAttributesRequest request, final AsyncHandler<SetQueueAttributesRequest, SetQueueAttributesResult> asyncHandler) {
        final SetQueueAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetQueueAttributesResult>(){

            @Override
            public SetQueueAttributesResult call() throws Exception {
                SetQueueAttributesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.executeSetQueueAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(String queueUrl, Map<String, String> attributes) {
        return this.setQueueAttributesAsync(new SetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributes(attributes));
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(String queueUrl, Map<String, String> attributes, AsyncHandler<SetQueueAttributesRequest, SetQueueAttributesResult> asyncHandler) {
        return this.setQueueAttributesAsync(new SetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributes(attributes), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

