/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.jpa.mapping.JpaMetamodelMappingContext;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.Assert;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public static final String JPA_MAPPING_CONTEXT_BEAN_NAME = "jpaMapppingContext";
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";

    @Override
    public String getRepositoryFactoryClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    @Override
    protected String getModulePrefix() {
        return "jpa";
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, transactionManagerRef == null ? DEFAULT_TRANSACTION_MANAGER_BEAN_NAME : transactionManagerRef);
        String entityManagerFactoryRef = this.getEntityManagerFactoryRef(source);
        if (entityManagerFactoryRef != null) {
            builder.addPropertyValue("entityManager", this.getEntityManagerBeanDefinitionFor(entityManagerFactoryRef, source));
        }
        builder.addPropertyReference("mappingContext", JPA_MAPPING_CONTEXT_BEAN_NAME);
    }

    private String getEntityManagerFactoryRef(RepositoryConfigurationSource source) {
        String entityManagerFactoryRef = source.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef == null ? "entityManagerFactory" : entityManagerFactoryRef;
    }

    private BeanDefinition getEntityManagerBeanDefinitionFor(String entityManagerFactoryBeanName, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition("org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(entityManagerFactoryBeanName);
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        Object source = configurationSource.getSource();
        JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName(registry, new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), source);
        BeanDefinition entityManagerBeanDefinitionFor = this.getEntityManagerBeanDefinitionFor(this.getEntityManagerFactoryRef(configurationSource), source);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class);
        builder.addPropertyValue("entityManager", entityManagerBeanDefinitionFor);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        definition.setSource(source);
        registry.registerBeanDefinition(JPA_MAPPING_CONTEXT_BEAN_NAME, definition);
        if (!JpaRepositoryConfigExtension.hasBean(PAB_POST_PROCESSOR, registry) && !registry.containsBeanDefinition("org.springframework.context.annotation.internalPersistenceAnnotationProcessor")) {
            JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName(registry, new RootBeanDefinition(PAB_POST_PROCESSOR), source);
        }
    }

    static class JpaMetamodelMappingContextFactoryBean
    extends AbstractFactoryBean<JpaMetamodelMappingContext> {
        private EntityManager entityManager;

        JpaMetamodelMappingContextFactoryBean() {
        }

        public void setEntityManager(EntityManager entityManager) {
            Assert.notNull(entityManager, "EntityManager must not be null!");
            this.entityManager = entityManager;
        }

        @Override
        public Class<?> getObjectType() {
            return JpaMetamodelMappingContext.class;
        }

        @Override
        protected JpaMetamodelMappingContext createInstance() throws Exception {
            Metamodel metamodel = this.entityManager.getMetamodel();
            Set<ManagedType<?>> managedTypes = metamodel.getManagedTypes();
            HashSet entitySources = new HashSet(managedTypes.size());
            for (ManagedType<?> type : managedTypes) {
                Class javaType = type.getJavaType();
                if (javaType == null) continue;
                entitySources.add(javaType);
            }
            JpaMetamodelMappingContext context = new JpaMetamodelMappingContext(metamodel);
            context.setInitialEntitySet(entitySources);
            context.initialize();
            return context;
        }

        @Override
        public void afterPropertiesSet() throws Exception {
            Assert.notNull(this.entityManager, "EntityManager must not be null!");
            super.afterPropertiesSet();
        }
    }
}

