/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.util.Stack;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class PropertyReferenceException
extends RuntimeException {
    private static final long serialVersionUID = -5254424051438976570L;
    private static final String ERROR_TEMPLATE = "No property %s found for type %s!";
    private final String propertyName;
    private final TypeInformation<?> type;
    private final Stack<PropertyPath> base;

    public PropertyReferenceException(String propertyName, TypeInformation<?> type, Stack<PropertyPath> base) {
        Assert.hasText(propertyName);
        Assert.notNull(type);
        this.propertyName = propertyName;
        this.type = type;
        this.base = base;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeInformation<?> getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(String.format(ERROR_TEMPLATE, this.propertyName, this.type.getType().getSimpleName()));
        if (!this.base.isEmpty()) {
            builder.append(" Traversed path: ").append(((PropertyPath)this.base.get(0)).toString()).append(".");
        }
        return builder.toString();
    }

    public PropertyPath getBaseProperty() {
        return this.base.isEmpty() ? null : this.base.peek();
    }
}

