/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Polygon
implements Iterable<Point>,
Shape {
    private static final long serialVersionUID = -2705040068154648988L;
    private final List<Point> points;

    public Polygon(Point x, Point y, Point z, Point ... others) {
        Assert.notNull(x, "X coordinate must not be null!");
        Assert.notNull(y, "Y coordinate must not be null!");
        Assert.notNull(z, "Z coordinate must not be null!");
        Assert.notNull(others);
        ArrayList<Point> points = new ArrayList<Point>(3 + others.length);
        points.addAll(Arrays.asList(x, y, z));
        points.addAll(Arrays.asList(others));
        this.points = Collections.unmodifiableList(points);
    }

    @PersistenceConstructor
    public Polygon(List<? extends Point> points) {
        Assert.notNull(points);
        ArrayList<Point> pointsToSet = new ArrayList<Point>(points.size());
        for (Point point : points) {
            Assert.notNull(point);
            pointsToSet.add(point);
        }
        this.points = Collections.unmodifiableList(pointsToSet);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    @Override
    public Iterator<Point> iterator() {
        return this.points.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Polygon)) {
            return false;
        }
        Polygon that = (Polygon)obj;
        return ((Object)this.points).equals(that.points);
    }

    public int hashCode() {
        return ((Object)this.points).hashCode();
    }

    public String toString() {
        return String.format("Polygon: [%s]", StringUtils.collectionToCommaDelimitedString(this.points));
    }
}

