/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.BaseEntity;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.storage.domain.StorageProviderType;
import org.hibernate.LazyInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;

public class DbUtil {
    private final Logger log = LoggerFactory.getLogger(DbUtil.class);
    private DuracloudRepoMgr repoMgr;
    private File workDir;

    public DbUtil(DuracloudRepoMgr repoMgr, File workDir) {
        this.repoMgr = repoMgr;
        this.workDir = workDir;
    }

    public void runCommand(COMMAND command) {
        System.out.println("Running DB Util with command " + command.name() + "\n\t using work directory: " + this.workDir.getAbsolutePath());
        if (!COMMAND.PUT.equals((Object)command)) {
            throw new UnsupportedOperationException("The " + command + " command is no longer supported.");
        }
        this.doPut();
    }

    private void doPut() {
        String[] files;
        for (String fileName : files = new String[]{"ServiceRepository", "StorageProviderAccount", "ServerDetails", "AccountInfo", "DuracloudUser", "DuracloudGroup", "UserInvitation", "AccountRights"}) {
            File inputFile = new File(this.workDir, fileName + ".xml");
            if (inputFile.length() <= 0L) continue;
            String xml = this.readFromFile(inputFile);
            List entities = (List)this.deserialize(xml);
            this.saveEntities(entities);
        }
    }

    private String readFromFile(File inFile) {
        try {
            return FileUtils.readFileToString(inFile, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read from file " + inFile + " due to error " + e.getMessage());
        }
    }

    private void saveEntities(List<BaseEntity> entities) {
        if (!entities.isEmpty()) {
            JpaRepository repo = this.getRepo(entities.get(0));
            for (BaseEntity entity : entities) {
                if (entity instanceof AccountInfo) {
                    AccountInfo sd = (AccountInfo)entity;
                    sd.setPrimaryStorageProviderAccount((StorageProviderAccount)this.repoMgr.getStorageProviderAccountRepo().findOne(sd.getPrimaryStorageProviderAccount().getId()));
                    Set<StorageProviderAccount> storageProviderAccounts = sd.getSecondaryStorageProviderAccounts();
                    try {
                        if (storageProviderAccounts.size() > 0) {
                            HashSet<StorageProviderAccount> accounts = new HashSet<StorageProviderAccount>();
                            for (StorageProviderAccount sp : storageProviderAccounts) {
                                StorageProviderAccount account = (StorageProviderAccount)this.repoMgr.getStorageProviderAccountRepo().findOne(sp.getId());
                                accounts.add(account);
                            }
                            sd.setSecondaryStorageProviderAccounts(accounts);
                            this.log.warn("Set a secondary storage provider to ServerDetails with id " + sd.getId());
                        }
                    }
                    catch (LazyInitializationException accounts) {
                    }
                    catch (Exception e) {
                        this.log.warn("Exception not handled!!!");
                        this.log.warn(e.toString());
                    }
                    repo.saveAndFlush(sd);
                    continue;
                }
                if (entity instanceof DuracloudGroup) {
                    DuracloudGroup dg = (DuracloudGroup)entity;
                    dg.setAccount((AccountInfo)this.repoMgr.getAccountRepo().findOne(dg.getAccount().getId()));
                    if (dg.getUsers().size() > 0) {
                        HashSet<DuracloudUser> users = new HashSet<DuracloudUser>();
                        for (DuracloudUser user : dg.getUsers()) {
                            users.add((DuracloudUser)this.repoMgr.getUserRepo().findOne(user.getId()));
                        }
                        dg.setUsers(users);
                    }
                    repo.saveAndFlush(dg);
                    continue;
                }
                if (entity instanceof AccountRights) {
                    AccountRights rights = (AccountRights)entity;
                    rights.setAccount((AccountInfo)this.repoMgr.getAccountRepo().findOne(rights.getAccount().getId()));
                    rights.setUser((DuracloudUser)this.repoMgr.getUserRepo().findOne(rights.getUser().getId()));
                    repo.saveAndFlush(rights);
                    continue;
                }
                if (entity instanceof UserInvitation) {
                    UserInvitation ui = (UserInvitation)entity;
                    ui.setAccount((AccountInfo)this.repoMgr.getAccountRepo().findOne(ui.getAccount().getId()));
                    repo.saveAndFlush(ui);
                    continue;
                }
                repo.saveAndFlush(entity);
            }
        }
    }

    private JpaRepository getRepo(BaseEntity item) {
        JpaRepository<DuracloudUser, Long> repo;
        if (item instanceof DuracloudUser) {
            repo = this.repoMgr.getUserRepo();
        } else if (item instanceof AccountInfo) {
            repo = this.repoMgr.getAccountRepo();
        } else if (item instanceof AccountRights) {
            repo = this.repoMgr.getRightsRepo();
        } else if (item instanceof UserInvitation) {
            repo = this.repoMgr.getUserInvitationRepo();
        } else if (item instanceof StorageProviderAccount) {
            repo = this.repoMgr.getStorageProviderAccountRepo();
        } else if (item instanceof DuracloudGroup) {
            repo = this.repoMgr.getGroupRepo();
        } else {
            throw new RuntimeException("Item is not a known type: " + item.getClass().getName());
        }
        return repo;
    }

    private Object deserialize(String xml) {
        return this.getXStream().fromXML(xml);
    }

    private XStream getXStream() {
        XStream xstream = new XStream(new DomDriver());
        xstream.setMode(1001);
        xstream.alias(DuracloudUser.class.getSimpleName(), DuracloudUser.class);
        xstream.alias(DuracloudGroup.class.getSimpleName(), DuracloudGroup.class);
        xstream.alias(AccountInfo.class.getSimpleName(), AccountInfo.class);
        xstream.alias(AccountRights.class.getSimpleName(), AccountRights.class);
        xstream.alias(UserInvitation.class.getSimpleName(), UserInvitation.class);
        xstream.alias(StorageProviderAccount.class.getSimpleName(), StorageProviderAccount.class);
        xstream.alias(Role.class.getSimpleName(), Role.class);
        xstream.alias(StorageProviderType.class.getSimpleName(), StorageProviderType.class);
        return xstream;
    }

    public static enum COMMAND {
        GET,
        PUT,
        CLEAR;

    }
}

