/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.MultiValueBinding;
import org.springframework.data.querydsl.binding.PathInformation;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslDefaultBinding;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class QuerydslPredicateBuilder {
    private final ConversionService conversionService;
    private final MultiValueBinding<?, ?> defaultBinding;
    private final Map<PathInformation, Path<?>> paths;
    private final EntityPathResolver resolver;

    public QuerydslPredicateBuilder(ConversionService conversionService, EntityPathResolver resolver) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        this.defaultBinding = new QuerydslDefaultBinding();
        this.conversionService = conversionService;
        this.paths = new ConcurrentHashMap();
        this.resolver = resolver;
    }

    public Predicate getPredicate(TypeInformation<?> type, MultiValueMap<String, String> values, QuerydslBindings bindings) {
        Assert.notNull(bindings, "Context must not be null!");
        BooleanBuilder builder = new BooleanBuilder();
        if (values.isEmpty()) {
            return builder.getValue();
        }
        for (Map.Entry entry : values.entrySet()) {
            Collection<Object> value;
            Predicate predicate;
            PathInformation propertyPath;
            String path;
            if (QuerydslPredicateBuilder.isSingleElementCollectionWithoutText((List)entry.getValue()) || !bindings.isPathAvailable(path = (String)entry.getKey(), type) || (propertyPath = bindings.getPropertyPath(path, type)) == null || (predicate = this.invokeBinding(propertyPath, bindings, value = this.convertToPropertyPathSpecificType((List)entry.getValue(), propertyPath))) == null) continue;
            builder.and(predicate);
        }
        return builder.getValue();
    }

    private Predicate invokeBinding(PathInformation dotPath, QuerydslBindings bindings, Collection<Object> values) {
        Path<?> path = this.getPath(dotPath, bindings);
        MultiValueBinding<Object, Path<?>> binding = bindings.getBindingForPath(dotPath);
        binding = binding == null ? this.defaultBinding : binding;
        return binding.bind(path, values);
    }

    private Path<?> getPath(PathInformation path, QuerydslBindings bindings) {
        Path<?> resolvedPath = bindings.getExistingPath(path);
        if (resolvedPath != null) {
            return resolvedPath;
        }
        resolvedPath = this.paths.get(path);
        if (resolvedPath != null) {
            return resolvedPath;
        }
        resolvedPath = path.reifyPath(this.resolver);
        this.paths.put(path, resolvedPath);
        return resolvedPath;
    }

    private Collection<Object> convertToPropertyPathSpecificType(List<String> source, PathInformation path) {
        Class<?> targetType = path.getLeafType();
        if (source.isEmpty() || QuerydslPredicateBuilder.isSingleElementCollectionWithoutText(source)) {
            return Collections.emptyList();
        }
        ArrayList<Object> target = new ArrayList<Object>(source.size());
        for (String value : source) {
            target.add(this.conversionService.canConvert(String.class, targetType) ? this.conversionService.convert(value, TypeDescriptor.forObject(value), QuerydslPredicateBuilder.getTargetTypeDescriptor(path)) : value);
        }
        return target;
    }

    private static TypeDescriptor getTargetTypeDescriptor(PathInformation path) {
        PropertyDescriptor descriptor = path.getLeafPropertyDescriptor();
        Class<?> owningType = path.getLeafParentType();
        String leafProperty = path.getLeafProperty();
        if (descriptor == null) {
            return TypeDescriptor.nested(ReflectionUtils.findField(owningType, leafProperty), 0);
        }
        return TypeDescriptor.nested(new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), leafProperty), 0);
    }

    private static boolean isSingleElementCollectionWithoutText(List<String> source) {
        return source.size() == 1 && !StringUtils.hasLength(source.get(0));
    }
}

