/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util;

import java.io.File;
import java.io.IOException;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DbUtil;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DbUtilDriver {
    private DbUtilDriver() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            DbUtilDriver.usage("Two arguments are required, you supplied: " + args.length);
            System.exit(1);
        }
        DbUtil.COMMAND command = null;
        String commandArg = args[0];
        if (commandArg.equalsIgnoreCase(DbUtil.COMMAND.PUT.name())) {
            command = DbUtil.COMMAND.PUT;
        } else {
            DbUtilDriver.usage("The first argument must PUT. The previously supported command GET and CLEAR have been removed since the move to MC 2.0.0 You supplied: " + commandArg);
            System.exit(1);
        }
        File workDir = new File(args[1]);
        if (!workDir.exists()) {
            DbUtilDriver.usage("The work directory must exist: " + workDir.getPath());
            System.exit(1);
        } else if (!workDir.isDirectory()) {
            DbUtilDriver.usage("The work directory must be a directory: " + workDir.getPath());
            System.exit(1);
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("jpa-config.xml");
        DuracloudRepoMgr repoMgr = context.getBean("repoMgr", DuracloudRepoMgr.class);
        DbUtil dbUtil = new DbUtil(repoMgr, workDir);
        dbUtil.runCommand(command);
    }

    private static void usage(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error: " + msg);
        sb.append("\n\n");
        sb.append("Usage: ");
        sb.append("\n\t");
        sb.append("DbUtilDriver [get] [work-dir]");
        sb.append("\n\n\t\t");
        sb.append("GET - retrieves and stores all db data in work-dir");
        sb.append("\n\n\t");
        sb.append("where [work-dir] is a directory from which data will be");
        sb.append("\n\n\t\t");
        sb.append("read");
        System.out.println(sb);
    }
}

